/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.spatial.arrange.fill;

import java.util.List;
import org.anchoranalysis.image.bean.spatial.arrange.fill.ExtentToArrange;

class CombinedWidthCalculator {
    public static int calculate(List<List<ExtentToArrange>> partitions, int width, double widthRatio) {
        if (width > 0) {
            if (widthRatio > 0.0) {
                return Math.max(width, CombinedWidthCalculator.calculateFromRatio(partitions, widthRatio));
            }
            return width;
        }
        return CombinedWidthCalculator.calculateFromRatio(partitions, widthRatio);
    }

    private static int calculateFromRatio(List<List<ExtentToArrange>> partitions, double widthRatio) {
        return (int)Math.round(widthRatio * CombinedWidthCalculator.averageRowWidth(partitions));
    }

    private static double averageRowWidth(List<List<ExtentToArrange>> partitions) {
        return partitions.stream().mapToInt(CombinedWidthCalculator::widthOfRow).average().getAsDouble();
    }

    private static int widthOfRow(List<ExtentToArrange> extents) {
        return extents.stream().mapToInt(ExtentToArrange::width).sum();
    }

    private CombinedWidthCalculator() {
    }
}

