/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.segment.binary;

import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.nonbean.segment.BinarySegmentationParameters;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.segment.binary.BinarySegmentation;
import org.anchoranalysis.image.bean.threshold.Thresholder;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;

public class BinarySegmentationThreshold
extends BinarySegmentation {
    @BeanField
    private Thresholder thresholder;

    @Override
    public BinaryVoxels<UnsignedByteBuffer> segment(VoxelsUntyped voxels, BinarySegmentationParameters parameters, Optional<ObjectMask> objectMask) throws SegmentationFailedException {
        try {
            return this.thresholder.threshold(voxels, BinaryValuesByte.getDefault(), objectMask.isPresent() ? Optional.empty() : parameters.getIntensityHistogram(), objectMask);
        }
        catch (OperationFailedException e) {
            throw new SegmentationFailedException(e);
        }
    }

    public Thresholder getThresholder() {
        return this.thresholder;
    }

    public void setThresholder(Thresholder thresholder) {
        this.thresholder = thresholder;
    }
}

