/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.nonbean.init;

import org.anchoranalysis.bean.initializable.InitializableBean;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.initializable.property.BeanInitializer;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.core.log.Logger;

class InitializingBridge<S extends InitializableBean<?, V>, T, V extends BeanInitialization>
implements CheckedFunction<S, T, OperationFailedException> {
    private final BeanInitializer<?> initializer;
    private final Logger logger;
    private final CheckedFunction<S, T, ProvisionFailedException> beanBridge;

    public T apply(S sourceObject) throws OperationFailedException {
        assert (this.logger != null);
        try {
            sourceObject.initRecursiveWithInitializer(this.initializer, this.logger);
            return (T)this.beanBridge.apply(sourceObject);
        }
        catch (ProvisionFailedException | InitializeException e) {
            throw new OperationFailedException(e);
        }
    }

    public InitializingBridge(BeanInitializer<?> initializer, Logger logger, CheckedFunction<S, T, ProvisionFailedException> beanBridge) {
        this.initializer = initializer;
        this.logger = logger;
        this.beanBridge = beanBridge;
    }
}

