/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.nonbean.init;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.bean.define.Define;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.initializable.property.BeanInitializer;
import org.anchoranalysis.bean.shared.dictionary.DictionaryInitialization;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.NamedProvider;
import org.anchoranalysis.core.identifier.provider.NamedProviderGetException;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.identifier.provider.store.SharedObjects;
import org.anchoranalysis.core.identifier.provider.store.StoreSupplier;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.feature.bean.list.FeatureListProvider;
import org.anchoranalysis.feature.initialization.FeatureRelatedInitialization;
import org.anchoranalysis.image.bean.nonbean.init.CombineStackProviders;
import org.anchoranalysis.image.bean.nonbean.init.PopulateStoreFromDefine;
import org.anchoranalysis.image.bean.provider.ChannelProvider;
import org.anchoranalysis.image.bean.provider.HistogramProvider;
import org.anchoranalysis.image.bean.provider.MaskProvider;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.bean.provider.stack.StackProvider;
import org.anchoranalysis.image.bean.segment.binary.BinarySegmentation;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.size.suggestion.ImageSizeSuggestion;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.math.histogram.Histogram;

public class ImageInitialization
implements BeanInitialization {
    public static final String DICTIONARY_IDENTIFIER = "input_dictionary";
    private final SharedObjects sharedObjects;
    private final Optional<ImageSizeSuggestion> suggestedSize;
    private final FeatureRelatedInitialization features;
    private final NamedProviderStore<Stack> stacks;
    private final NamedProviderStore<Histogram> histograms;
    private final NamedProviderStore<ObjectCollection> objects;
    private final NamedProviderStore<Channel> channels;
    private final NamedProviderStore<Mask> masks;
    private final NamedProviderStore<BinarySegmentation> binarySegmentations;

    public ImageInitialization(SharedObjects sharedObjects) {
        this(sharedObjects, Optional.empty());
    }

    public ImageInitialization(SharedObjects sharedObjects, Optional<ImageSizeSuggestion> suggestedSize) {
        this.sharedObjects = sharedObjects;
        this.suggestedSize = suggestedSize;
        this.features = FeatureRelatedInitialization.create((SharedObjects)sharedObjects);
        this.stacks = sharedObjects.getOrCreate(Stack.class);
        this.histograms = sharedObjects.getOrCreate(Histogram.class);
        this.objects = sharedObjects.getOrCreate(ObjectCollection.class);
        this.channels = sharedObjects.getOrCreate(Channel.class);
        this.masks = sharedObjects.getOrCreate(Mask.class);
        this.binarySegmentations = sharedObjects.getOrCreate(BinarySegmentation.class);
    }

    public NamedProviderStore<Path> filePaths() {
        return this.features.getFilePaths().getFilePaths();
    }

    public NamedProviderStore<Dictionary> dictionaries() {
        return this.dictionaryInitialization().getDictionaries();
    }

    public Path modelDirectory() {
        return this.sharedObjects.getContext().getModelDirectory();
    }

    public DictionaryInitialization dictionaryInitialization() {
        return this.features.getDictionary();
    }

    public FeatureRelatedInitialization featuresInitialization() {
        return this.features;
    }

    public NamedProvider<Stack> combinedStacks() {
        return new CombineStackProviders((NamedProvider<Stack>)this.stacks, (NamedProvider<Channel>)this.channels, (NamedProvider<Mask>)this.masks);
    }

    public void addDictionary(String identifier, Dictionary toAdd) throws OperationFailedException {
        this.dictionaries().add(identifier, () -> toAdd);
    }

    public void addStack(String identifier, Stack toAdd) throws OperationFailedException {
        this.stacks().add(identifier, () -> toAdd);
    }

    public void addStacksFrom(NamedProvider<Stack> source) throws OperationFailedException {
        try {
            for (String id : source.keys()) {
                this.addStack(id, (Stack)source.getException(id));
            }
        }
        catch (NamedProviderGetException e) {
            throw new OperationFailedException(e.summarize());
        }
    }

    public void addObjectsFrom(NamedProvider<ObjectCollection> source) throws OperationFailedException {
        for (String id : source.keys()) {
            this.addToObjects(id, (StoreSupplier<ObjectCollection>)((StoreSupplier)() -> {
                try {
                    return (ObjectCollection)source.getException(id);
                }
                catch (NamedProviderGetException e) {
                    throw new OperationFailedException(e.summarize());
                }
            }));
        }
    }

    public void populate(BeanInitializer<?> propertyInitializer, Define define, Logger logger) throws OperationFailedException {
        this.features.populate(define.listFor(FeatureListProvider.class), logger);
        PopulateStoreFromDefine populate = new PopulateStoreFromDefine(define, propertyInitializer, logger);
        populate.copyInitialize(BinarySegmentation.class, this.binarySegmentations);
        populate.copyProviderInitialize(MaskProvider.class, this.masks);
        populate.copyProviderInitialize(ChannelProvider.class, this.channels);
        populate.copyProviderInitialize(ObjectCollectionProvider.class, this.objects);
        populate.copyProviderInitialize(HistogramProvider.class, this.histograms);
        populate.copyProviderInitialize(StackProvider.class, this.stacks);
    }

    public void addSharedObjectsDictionary(Optional<SharedObjects> sharedObjects, Optional<Dictionary> dictionary) throws OperationFailedException {
        if (sharedObjects.isPresent()) {
            ImageInitialization copyFrom = new ImageInitialization(sharedObjects.get());
            this.addStacksFrom((NamedProvider<Stack>)copyFrom.stacks());
            this.addObjectsFrom((NamedProvider<ObjectCollection>)copyFrom.objects());
        }
        if (dictionary.isPresent()) {
            this.addDictionary(DICTIONARY_IDENTIFIER, dictionary.get());
        }
    }

    private void addToObjects(String identifier, StoreSupplier<ObjectCollection> objects) throws OperationFailedException {
        this.objects().add(identifier, objects);
    }

    public SharedObjects sharedObjects() {
        return this.sharedObjects;
    }

    public Optional<ImageSizeSuggestion> suggestedSize() {
        return this.suggestedSize;
    }

    public NamedProviderStore<Stack> stacks() {
        return this.stacks;
    }

    public NamedProviderStore<Histogram> histograms() {
        return this.histograms;
    }

    public NamedProviderStore<ObjectCollection> objects() {
        return this.objects;
    }

    public NamedProviderStore<Channel> channels() {
        return this.channels;
    }

    public NamedProviderStore<Mask> masks() {
        return this.masks;
    }

    public NamedProviderStore<BinarySegmentation> binarySegmentations() {
        return this.binarySegmentations;
    }
}

