/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.displayer;

import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.image.bean.displayer.StackDisplayer;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.convert.attached.ChannelConverterAttached;
import org.anchoranalysis.image.core.channel.convert.attached.channel.IntensityRange;
import org.anchoranalysis.image.core.channel.convert.attached.channel.UpperLowerQuantileIntensity;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;

public class IntensityQuantiles
extends StackDisplayer {
    @BeanField
    private double quantileLower = 1.0E-4;
    @BeanField
    private double quantileUpper = 0.9999;

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        if (this.quantileLower >= this.quantileUpper) {
            throw new BeanMisconfiguredException(String.format("The lower-quantile (%f) is not lower than the upper-quantile (%f)", this.quantileLower, this.quantileUpper));
        }
    }

    @Override
    protected ChannelConverterAttached<Channel, UnsignedByteBuffer> createConverterFor(VoxelDataType dataType) {
        if (dataType.bitDepth() <= 16) {
            return new UpperLowerQuantileIntensity(this.quantileLower, this.quantileUpper);
        }
        return new IntensityRange();
    }

    public double getQuantileLower() {
        return this.quantileLower;
    }

    public void setQuantileLower(double quantileLower) {
        this.quantileLower = quantileLower;
    }

    public double getQuantileUpper() {
        return this.quantileUpper;
    }

    public void setQuantileUpper(double quantileUpper) {
        this.quantileUpper = quantileUpper;
    }
}

