/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.shared.regex;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.shared.regex.RegEx;
import org.anchoranalysis.core.functional.OptionalFactory;

public class RegExSimple
extends RegEx {
    @BeanField
    private String expression;
    private Pattern pattern = null;

    public RegExSimple(String matchString) {
        this.expression = matchString;
    }

    @Override
    public Optional<String[]> match(String string) {
        this.createPatternIfNeeded();
        Matcher matcher = this.pattern.matcher(string);
        return OptionalFactory.create((boolean)matcher.matches(), () -> this.arrayFromMatcher(matcher));
    }

    public String toString() {
        return String.format("regEx(%s)", this.expression);
    }

    private void createPatternIfNeeded() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.expression);
        }
    }

    private String[] arrayFromMatcher(Matcher matcher) {
        String[] out = new String[matcher.groupCount()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = matcher.group(i + 1);
        }
        return out;
    }

    public RegExSimple() {
    }

    public RegExSimple(String expression, Pattern pattern) {
        this.expression = expression;
        this.pattern = pattern;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }
}

