/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.xml.exception;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.anchoranalysis.bean.exception.BeanStrangeException;
import org.anchoranalysis.bean.xml.exception.BeanXMLException;
import org.anchoranalysis.core.exception.combinable.AnchorCombinableException;

public class LocalisedBeanException
extends AnchorCombinableException {
    private static final long serialVersionUID = 1L;

    public LocalisedBeanException(String message, Throwable cause) {
        super(message, cause);
    }

    protected boolean canExceptionBeCombined(Throwable exception) {
        return exception instanceof LocalisedBeanException;
    }

    public Throwable summarize() {
        return super.combineDescriptionsRecursively("at ", "\n-> ");
    }

    public BeanXMLException summarizeIgnoreIdenticalFilePath(Path pathMatch) {
        if (this.hasNoCombinableNestedExceptions()) {
            Path pathDescription = Paths.get(this.getDescription(), new String[0]);
            try {
                if (Files.isSameFile(pathMatch, pathDescription)) {
                    return new BeanXMLException(this.getCause());
                }
                return new BeanXMLException(this.summarize());
            }
            catch (IOException e) {
                throw new BeanStrangeException("An IO error has prevented comparisons of paths", e);
            }
        }
        return new BeanXMLException(this.summarize());
    }

    protected boolean canExceptionBeSkipped(Throwable exception) {
        return true;
    }

    protected String createMessageForDescription(String message) {
        return message;
    }
}

