/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.xml.exception;

import java.nio.file.NoSuchFileException;
import lombok.Generated;
import org.anchoranalysis.bean.xml.exception.BeanXMLException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationRuntimeException;

public class FriendlyExceptionCreator {
    public static Throwable maybeCreateUserFriendlyException(Throwable e) {
        if (e instanceof ConfigurationRuntimeException || e instanceof ConfigurationException) {
            if (e.getCause() != null) {
                return FriendlyExceptionCreator.maybeCreateUserFriendlyException(e.getCause());
            }
            return new BeanXMLException(e);
        }
        if (e instanceof ClassNotFoundException) {
            ClassNotFoundException eCast = (ClassNotFoundException)e;
            return new BeanXMLException(String.format("Class '%s' is referred to in BeanXML but cannot be found on classpath.%nPlease check spelling of config-class attributes, and make sure relevant plugins are installed.", eCast.getMessage()));
        }
        if (e instanceof NoClassDefFoundError) {
            NoClassDefFoundError eCast = (NoClassDefFoundError)e;
            return new BeanXMLException(String.format("Class '%s' is referred to in BeanXML but cannot be found on classpath.%nPlease check spelling of config-class attributes, and make sure relevant plugins are installed.", eCast.getMessage()));
        }
        if (e instanceof NoSuchFileException) {
            NoSuchFileException eCast = (NoSuchFileException)e;
            return new BeanXMLException(String.format("Cannot find included file: %s", eCast.getMessage()));
        }
        return e;
    }

    @Generated
    private FriendlyExceptionCreator() {
    }
}

