/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.xml;

import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.define.DefineFactory;
import org.anchoranalysis.bean.xml.factory.AnchorBeanFactory;
import org.anchoranalysis.bean.xml.factory.AnchorDefaultBeanFactory;
import org.anchoranalysis.bean.xml.factory.IncludeBeanFactory;
import org.anchoranalysis.bean.xml.factory.IncludeListBeanFactory;
import org.anchoranalysis.bean.xml.factory.ListBeanFactory;
import org.anchoranalysis.bean.xml.factory.ReplacePropertyBeanFactory;
import org.anchoranalysis.bean.xml.factory.primitive.DoubleListFactory;
import org.anchoranalysis.bean.xml.factory.primitive.DoubleSetFactory;
import org.anchoranalysis.bean.xml.factory.primitive.IntegerListFactory;
import org.anchoranalysis.bean.xml.factory.primitive.IntegerSetFactory;
import org.anchoranalysis.bean.xml.factory.primitive.StringListFactory;
import org.anchoranalysis.bean.xml.factory.primitive.StringSetFactory;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.apache.commons.configuration.beanutils.BeanFactory;
import org.apache.commons.configuration.beanutils.BeanHelper;

public final class RegisterBeanFactories {
    private static boolean calledRegisterAllPackage = false;

    public static AnchorDefaultBeanFactory registerAllPackageBeanFactories() {
        if (calledRegisterAllPackage) {
            return (AnchorDefaultBeanFactory)BeanHelper.getDefaultBeanFactory();
        }
        RegisterBeanFactories.register("stringSet", new StringSetFactory());
        RegisterBeanFactories.register("integerSet", new IntegerSetFactory());
        RegisterBeanFactories.register("doubleSet", new DoubleSetFactory());
        RegisterBeanFactories.register("stringList", new StringListFactory());
        RegisterBeanFactories.register("integerList", new IntegerListFactory());
        RegisterBeanFactories.register("doubleList", new DoubleListFactory());
        RegisterBeanFactories.register("include", new IncludeBeanFactory());
        RegisterBeanFactories.register("listInclude", new IncludeListBeanFactory());
        RegisterBeanFactories.register("define", new DefineFactory());
        RegisterBeanFactories.register("list", (List<T> list) -> list);
        calledRegisterAllPackage = true;
        BeanInstanceMap defaultInstances = new BeanInstanceMap();
        AnchorDefaultBeanFactory defaultFactory = new AnchorDefaultBeanFactory(defaultInstances);
        BeanHelper.setDefaultBeanFactory((BeanFactory)defaultFactory);
        RegisterBeanFactories.register("replaceProperty", new ReplacePropertyBeanFactory(defaultInstances));
        return defaultFactory;
    }

    public static BeanInstanceMap getDefaultInstances() {
        if (calledRegisterAllPackage) {
            return ((AnchorDefaultBeanFactory)BeanHelper.getDefaultBeanFactory()).getDefaultInstances();
        }
        throw new AnchorFriendlyRuntimeException("Unable to retrieve defaultInstances as registerAllPackageBeanFactories() has never been called");
    }

    public static void register(String name, AnchorBeanFactory factory) {
        BeanHelper.registerBeanFactory((String)name, (BeanFactory)factory);
    }

    public static <T> void register(String factoryName, Function<List<T>, Object> creator) {
        RegisterBeanFactories.register(factoryName, new ListBeanFactory<T>(creator));
    }

    public static boolean isCalledRegisterAllPackage() {
        return calledRegisterAllPackage;
    }

    @Generated
    private RegisterBeanFactories() {
    }
}

