/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import javax.xml.parsers.ParserConfigurationException;
import lombok.Generated;
import org.anchoranalysis.bean.xml.exception.BeanXMLException;
import org.anchoranalysis.core.serialize.XMLParser;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.xml.sax.SAXParseException;

class HelperReadXML {
    public static XMLConfiguration readBeanXMLFromFilesystem(Path filePath) throws BeanXMLException {
        try {
            File configFile = filePath.toFile();
            return HelperReadXML.readBeanXMLFromStream(new FileInputStream(configFile));
        }
        catch (FileNotFoundException e) {
            throw HelperReadXML.createIncludedFileFailedException(e.getMessage());
        }
    }

    private static XMLConfiguration readBeanXMLFromStream(InputStream source) throws BeanXMLException {
        try {
            XMLConfiguration config = new XMLConfiguration();
            config.setDocumentBuilder(XMLParser.createBuilderWithDefaultErrorHandler());
            config.load(source);
            return config;
        }
        catch (ConfigurationException e) {
            throw HelperReadXML.convertConfigurationException(e);
        }
        catch (ParserConfigurationException e) {
            throw new BeanXMLException("An error occurred creating the DocumentBuilder for reading xml", e);
        }
    }

    private static BeanXMLException convertConfigurationException(ConfigurationException exc) {
        Throwable throwable = exc.getCause();
        if (throwable instanceof SAXParseException) {
            SAXParseException causeCast = (SAXParseException)throwable;
            return new BeanXMLException(HelperReadXML.locationOfXMLError(causeCast), exc.getCause());
        }
        if (exc.getCause() instanceof FileNotFoundException || exc.getCause() instanceof NoSuchFileException) {
            return HelperReadXML.createIncludedFileFailedException(exc.getCause().getMessage());
        }
        return new BeanXMLException(exc);
    }

    private static BeanXMLException createIncludedFileFailedException(String filePath) {
        return new BeanXMLException(String.format("Cannot find included file: %s", filePath));
    }

    private static String locationOfXMLError(SAXParseException e) {
        return String.format("At Line=%d Column=%d", e.getLineNumber(), e.getColumnNumber());
    }

    @Generated
    private HelperReadXML() {
    }
}

