/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.permute.assign;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.permute.assign.AssignPermutationException;
import org.anchoranalysis.bean.permute.assign.FindBean;
import org.anchoranalysis.bean.permute.assign.PermutationAssigner;

class SingleAssigner
implements PermutationAssigner {
    private List<Field> listFields = new ArrayList<Field>();

    public SingleAssigner() {
    }

    public SingleAssigner(Field field) {
        this.addField(field);
    }

    public void addField(Field field) {
        this.listFields.add(field);
    }

    @Override
    public void assignValue(AnchorBean<?> bean, Object value) throws AssignPermutationException {
        try {
            int numberIntermediate = this.listFields.size() - 1;
            AnchorBean<?> currentBean = bean;
            for (int i = 0; i < numberIntermediate; ++i) {
                Field field = this.listFields.get(i);
                currentBean = FindBean.beanFor(field, currentBean);
            }
            Field finalField = this.listFields.get(numberIntermediate);
            Object valMaybeConverted = SingleAssigner.maybeConvert(value, finalField.getType());
            finalField.set(currentBean, valMaybeConverted);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssignPermutationException("An illegal argument or access exception occurred setting a permutation on the bean");
        }
    }

    private static Object maybeConvert(Object val, Class<?> targetType) {
        if (targetType.equals(String.class)) {
            return val.toString();
        }
        return val;
    }
}

