/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.initializable;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.initializable.HelperInit;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.initializable.property.BeanInitializer;
import org.anchoranalysis.bean.initializable.property.InitializationParameterAssigner;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.log.Logger;

public abstract class InitializableBean<B, P extends BeanInitialization>
extends AnchorBean<B> {
    private final BeanInitializer<P> beanInitializer;
    private final InitializationParameterAssigner propertyInitializer;
    private Optional<P> initialization = Optional.empty();
    private Logger logger;

    public void initialize(P parameters, Logger logger) throws InitializeException {
        this.initialization = Optional.of(parameters);
        this.logger = logger;
        this.onInitialization(parameters);
    }

    public void onInitialization(P initialization) throws InitializeException {
    }

    public void initRecursiveWithInitializer(BeanInitializer<?> initializer, Logger logger) throws InitializeException {
        HelperInit.initializeRecursive(this, initializer, logger);
    }

    public void initializeRecursive(P parameters, Logger logger) throws InitializeException {
        this.beanInitializer.setParam(parameters);
        HelperInit.initializeRecursive(this, this.beanInitializer, logger);
    }

    public boolean isInitialized() {
        return this.initialization.isPresent();
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected P getInitialization() throws InitializeException {
        return (P)((BeanInitialization)this.initialization.orElseThrow(() -> new InitializeException("No initialization-parameters exist as the been has not been initialized")));
    }

    @Generated
    protected InitializableBean(BeanInitializer<P> beanInitializer, InitializationParameterAssigner propertyInitializer) {
        this.beanInitializer = beanInitializer;
        this.propertyInitializer = propertyInitializer;
    }

    @Generated
    public InitializationParameterAssigner getPropertyInitializer() {
        return this.propertyInitializer;
    }
}

