/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean;

import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.FieldAccessor;
import org.anchoranalysis.bean.HelperReflection;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.bean.exception.BeanStrangeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;

class HelperBeanFields {
    public static String describeChildBeans(AnchorBean<?> bean) {
        try {
            List descriptions = FunctionalList.mapToListOptional(bean.fields(), OperationFailedException.class, field -> HelperBeanFields.maybeDescribeChildBean(bean, field));
            return String.join((CharSequence)", ", descriptions);
        }
        catch (OperationFailedException e) {
            throw new BeanStrangeException("Failed to describe child beans", e);
        }
    }

    public static List<Field> createListBeanPropertyFields(Class<?> clss) {
        List<Field> allFields = HelperReflection.findAllFields(clss);
        return FunctionalList.filterAndMapToList(allFields, field -> field.isAnnotationPresent(BeanField.class), field -> {
            field.setAccessible(true);
            return field;
        });
    }

    private static String describeBean(AnchorBean<?> bean) {
        StringBuilder builder = new StringBuilder();
        builder.append(bean.getBeanName());
        builder.append("(");
        builder.append(HelperBeanFields.describeChildBeans(bean));
        builder.append(")");
        return builder.toString();
    }

    private static Optional<String> maybeDescribeChildBean(AnchorBean<?> bean, Field field) throws OperationFailedException {
        try {
            FieldAccessor.fieldFromBean(bean, field);
            return Optional.of(String.format("%s=%s", field.getName(), HelperBeanFields.describeField(field, bean)));
        }
        catch (IllegalAccessException | IllegalArgumentException | BeanMisconfiguredException | OperationFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private static String describeField(Field field, AnchorBean<?> bean) throws OperationFailedException {
        try {
            Object value;
            Object object = value = field.get(bean);
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnchorBean.class, List.class, String.class, Integer.class, Double.class, Float.class, Byte.class, Short.class, Long.class, Boolean.class}, (Object)object, n)) {
                case 0 -> {
                    AnchorBean anchorBean = (AnchorBean)object;
                    yield HelperBeanFields.describeBean(anchorBean);
                }
                case 1 -> {
                    List ignored = (List)object;
                    yield "list";
                }
                case 2 -> {
                    String valueAsString = (String)object;
                    yield "'" + valueAsString + "'";
                }
                case 3 -> {
                    Integer valueAsInt = (Integer)object;
                    yield Integer.toString(valueAsInt);
                }
                case 4 -> {
                    Double valueAsDouble = (Double)object;
                    yield Double.toString(valueAsDouble);
                }
                case 5 -> {
                    Float valueAsFloat = (Float)object;
                    yield Float.toString(valueAsFloat.floatValue());
                }
                case 6 -> {
                    Byte valueAsByte = (Byte)object;
                    yield Byte.toString(valueAsByte);
                }
                case 7 -> {
                    Short valueAsShort = (Short)object;
                    yield Short.toString(valueAsShort);
                }
                case 8 -> {
                    Long valueAsLong = (Long)object;
                    yield Long.toString(valueAsLong);
                }
                case 9 -> {
                    Boolean valueAsBoolean = (Boolean)object;
                    if (Boolean.TRUE.equals(valueAsBoolean)) {
                        yield "true";
                    }
                    yield "false";
                }
                case -1 -> "null";
                default -> throw new OperationFailedException("Unknown bean type: " + value.getClass().getSimpleName());
            };
        }
        catch (IllegalAccessException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Generated
    private HelperBeanFields() {
    }
}

