/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean;

import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.HelperBeanFields;
import org.anchoranalysis.bean.HelperCheckMisconfigured;
import org.anchoranalysis.bean.HelperDuplication;
import org.anchoranalysis.bean.HelperFindChildren;
import org.anchoranalysis.bean.exception.BeanDuplicateException;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;

public abstract class AnchorBean<F> {
    private List<Field> listBeanFields;
    @Nullable
    private Path localPath;

    public final String getBeanName() {
        return this.getClass().getSimpleName();
    }

    public String describeBean() {
        return this.getBeanName();
    }

    public Optional<Path> getLocalPath() {
        return Optional.ofNullable(this.localPath);
    }

    public String toString() {
        return this.describeBean();
    }

    public void localise(Path path) throws BeanMisconfiguredException {
        if (path != null && !path.isAbsolute()) {
            throw new BeanMisconfiguredException(String.format("A bean may not be localized with a relative path: %s", path));
        }
        this.localPath = path;
    }

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        HelperCheckMisconfigured helper = new HelperCheckMisconfigured(defaultInstances);
        helper.checkMisconfiguredWithFields(this, this.fields());
    }

    public F duplicateBean() {
        try {
            return (F)HelperDuplication.duplicate(this);
        }
        catch (BeanDuplicateException e) {
            throw new BeanDuplicateException(String.format("Error occurred while duplicating bean %s%n", this.getBeanName()), (Throwable)((Object)e));
        }
    }

    protected String describeChildren() {
        return HelperBeanFields.describeChildBeans(this);
    }

    public <T extends AnchorBean<?>> List<T> findFieldsOfClass(Class<?> match) throws BeanMisconfiguredException {
        return HelperFindChildren.findChildrenOfClass(this, this.fields(), match);
    }

    public List<Field> fields() {
        if (this.listBeanFields == null) {
            this.listBeanFields = HelperBeanFields.createListBeanPropertyFields(this.getClass());
        }
        return this.listBeanFields;
    }
}

