/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.annotation.io.mark;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import lombok.Generated;
import org.anchoranalysis.annotation.Annotation;
import org.anchoranalysis.annotation.io.AnnotationWriter;
import org.anchoranalysis.annotation.io.mark.TempPathCreator;
import org.anchoranalysis.annotation.mark.DualMarksAnnotation;
import org.anchoranalysis.core.serialize.XStreamSerializer;
import org.anchoranalysis.core.system.path.DirectoryCreator;

public class DualMarksAnnotationWriter<T>
implements AnnotationWriter<DualMarksAnnotation<T>> {
    private boolean disablePathModification = false;

    @Override
    public void write(DualMarksAnnotation<T> annotation, Path path) throws IOException {
        Path annotationPathForDeletion;
        Path annotationPathChosen;
        Path annotationPathUnfinished = TempPathCreator.deriveTempPath(path);
        if (annotation.isFinished() || this.disablePathModification) {
            annotationPathChosen = path;
            annotationPathForDeletion = annotationPathUnfinished;
        } else {
            annotationPathChosen = annotationPathUnfinished;
            annotationPathForDeletion = path;
        }
        DualMarksAnnotationWriter.saveAnnotationNoPathChange(annotation, annotationPathChosen, annotationPathForDeletion);
    }

    private static void saveAnnotationNoPathChange(Annotation annotation, Path annotationPath, Path annotationPathForDeletion) throws IOException {
        DirectoryCreator.createNecessaryDirectories((Path)annotationPath);
        XStreamSerializer.serializeObjectToFile((Object)annotation, (Path)annotationPath);
        if (!annotationPathForDeletion.equals(annotationPath)) {
            Files.deleteIfExists(annotationPathForDeletion);
        }
    }

    @Generated
    public DualMarksAnnotationWriter() {
    }

    @Generated
    public DualMarksAnnotationWriter(boolean disablePathModification) {
        this.disablePathModification = disablePathModification;
    }
}

