/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.annotation.io.image.findable;

import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.annotation.io.image.findable.Findable;
import org.anchoranalysis.core.log.Logger;

public final class NotFound<T>
implements Findable<T> {
    private final Path path;
    private final String reason;

    @Override
    public Optional<T> getOrLog(String name, Logger logger) {
        logger.messageLogger().logFormatted("Cannot find %s: %s at %s", new Object[]{name, this.reason, this.path});
        return Optional.empty();
    }

    @Generated
    public NotFound(Path path, String reason) {
        this.path = path;
        this.reason = reason;
    }

    @Generated
    public Path getPath() {
        return this.path;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotFound)) {
            return false;
        }
        NotFound other = (NotFound)o;
        Path this$path = this.getPath();
        Path other$path = other.getPath();
        if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NotFound(path=" + String.valueOf(this.getPath()) + ", reason=" + this.getReason() + ")";
    }
}

