/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.annotation.io.image;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.annotation.image.ImageLabelAnnotation;
import org.anchoranalysis.annotation.io.AnnotationReader;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.io.input.InputReadFailedException;

public class ImageLabelAnnotationReader
implements AnnotationReader<ImageLabelAnnotation> {
    @Override
    public Optional<ImageLabelAnnotation> read(Path path, OperationContext context) throws InputReadFailedException {
        Optional<ImageLabelAnnotation> optional;
        FileReader fileReader = new FileReader(path.toFile());
        try {
            optional = Optional.of(ImageLabelAnnotationReader.readFromFile(fileReader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InputReadFailedException("A failure opening the annotation file for reading");
            }
        }
        fileReader.close();
        return optional;
    }

    private static ImageLabelAnnotation readFromFile(FileReader fileReader) throws InputReadFailedException {
        ImageLabelAnnotation imageLabelAnnotation;
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            String label = bufferedReader.readLine();
            if (ImageLabelAnnotationReader.hasAnotherLine(bufferedReader)) {
                throw new InputReadFailedException("We expect the a whole-image label to be in a text file with a single line only");
            }
            imageLabelAnnotation = new ImageLabelAnnotation(label);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new InputReadFailedException("A failure occurred reading a line from the annotation file");
            }
        }
        bufferedReader.close();
        return imageLabelAnnotation;
    }

    private static boolean hasAnotherLine(BufferedReader bufferedReader) throws IOException {
        String nextLine = bufferedReader.readLine();
        return nextLine != null;
    }
}

