/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.annotation.io.bean.comparer;

import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.annotation.io.assignment.AssignOverlappingObjects;
import org.anchoranalysis.annotation.io.assignment.OverlappingObjects;
import org.anchoranalysis.annotation.io.assignment.generator.AssignmentColorPool;
import org.anchoranalysis.annotation.io.assignment.generator.AssignmentGenerator;
import org.anchoranalysis.annotation.io.assignment.generator.DrawColoredObjects;
import org.anchoranalysis.annotation.io.bean.comparer.ComparableSource;
import org.anchoranalysis.annotation.io.image.findable.Findable;
import org.anchoranalysis.annotation.mark.AnnotationWithMarks;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.NonEmpty;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.shared.color.scheme.ColorScheme;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.identifier.name.NameValue;
import org.anchoranalysis.core.identifier.name.SimpleNameValue;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.initialization.FeatureRelatedInitialization;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.feature.bean.evaluator.FeatureEvaluator;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;

public class MultipleComparer
extends AnchorBean<MultipleComparer> {
    @BeanField
    private FeatureEvaluator<FeatureInputPairObjects> featureEvaluator;
    @BeanField
    private double maxCost = 1.0;
    @BeanField
    @NonEmpty
    private List<NamedBean<ComparableSource>> sources = Arrays.asList(new NamedBean[0]);
    @BeanField
    private boolean flatten = false;

    public List<NameValue<Stack>> createComparisonStacks(AnnotationWithMarks annotation, DisplayStack background, Path annotationPath, ColorScheme colorScheme, Path modelDirectory, OperationContext context, boolean debugMode) throws CreateException {
        FeatureRelatedInitialization initialization = FeatureRelatedInitialization.create((Logger)context.getLogger(), (Path)modelDirectory);
        try {
            this.featureEvaluator.initializeRecursive((BeanInitialization)initialization, context.getLogger());
        }
        catch (InitializeException e) {
            throw new CreateException((Throwable)e);
        }
        ArrayList<NameValue<Stack>> out = new ArrayList<NameValue<Stack>>();
        for (NamedBean<ComparableSource> source : this.sources) {
            Findable<ObjectCollection> compareObjects;
            ObjectCollection annotationObjects = annotation.convertToObjects(background.dimensions());
            try {
                compareObjects = ((ComparableSource)source.getValue()).loadAsObjects(annotationPath, background.dimensions(), debugMode, context);
            }
            catch (InputReadFailedException e) {
                throw new CreateException((Throwable)e);
            }
            Optional<ObjectCollection> foundObjects = compareObjects.getOrLog(source.getName(), context.getLogger());
            if (!foundObjects.isPresent()) continue;
            out.add((NameValue<Stack>)this.compare(annotationObjects, foundObjects.get(), background, source.getName(), colorScheme));
        }
        return out;
    }

    private SimpleNameValue<Stack> compare(ObjectCollection annotationObjects, ObjectCollection compareObjects, DisplayStack background, String rightName, ColorScheme colorScheme) throws CreateException {
        MultipleComparer.removeObjectsWithNoPixels(annotationObjects);
        MultipleComparer.removeObjectsWithNoPixels(compareObjects);
        try {
            OverlappingObjects assignment = new AssignOverlappingObjects(this.featureEvaluator, this.flatten).createAssignment(annotationObjects, compareObjects, this.maxCost, background.dimensions());
            AssignmentGenerator generator = new AssignmentGenerator(new DrawColoredObjects(background, this.flatten, 3), numberPaired -> new AssignmentColorPool(numberPaired, colorScheme), (Tuple2<String, String>)Tuple.of((Object)"annotator", (Object)rightName), true);
            return new SimpleNameValue(rightName, (Object)generator.transform(assignment));
        }
        catch (FeatureCalculationException | OutputWriteFailedException e1) {
            throw new CreateException(e1);
        }
    }

    private static void removeObjectsWithNoPixels(ObjectCollection objects) {
        Iterator itr = objects.iterator();
        while (itr.hasNext()) {
            ObjectMask object = (ObjectMask)itr.next();
            if (object.numberVoxelsOn() != 0) continue;
            itr.remove();
        }
    }

    @Generated
    public FeatureEvaluator<FeatureInputPairObjects> getFeatureEvaluator() {
        return this.featureEvaluator;
    }

    @Generated
    public void setFeatureEvaluator(FeatureEvaluator<FeatureInputPairObjects> featureEvaluator) {
        this.featureEvaluator = featureEvaluator;
    }

    @Generated
    public double getMaxCost() {
        return this.maxCost;
    }

    @Generated
    public void setMaxCost(double maxCost) {
        this.maxCost = maxCost;
    }

    @Generated
    public List<NamedBean<ComparableSource>> getSources() {
        return this.sources;
    }

    @Generated
    public void setSources(List<NamedBean<ComparableSource>> sources) {
        this.sources = sources;
    }

    @Generated
    public boolean isFlatten() {
        return this.flatten;
    }

    @Generated
    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }
}

