/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.annotation.io.assignment.generator;

import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.function.IntFunction;
import lombok.Generated;
import org.anchoranalysis.annotation.io.assignment.Assignment;
import org.anchoranalysis.annotation.io.assignment.generator.AssignmentColorPool;
import org.anchoranalysis.annotation.io.assignment.generator.DrawColoredObjects;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.bean.provider.stack.StackProvider;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.bean.stack.combine.StackProviderWithLabel;
import org.anchoranalysis.image.io.stack.input.TileStackProviders;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributes;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributesFactory;
import org.anchoranalysis.image.io.stack.output.generator.RasterGeneratorSelectFormat;
import org.anchoranalysis.image.io.stack.output.generator.StackGenerator;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;

public class AssignmentGenerator
extends RasterGeneratorSelectFormat<Assignment<ObjectMask>> {
    private final DrawColoredObjects objectDrawer;
    private final IntFunction<AssignmentColorPool> colorPoolCreator;
    private final Tuple2<String, String> names;
    private final boolean appendUnassignedCount;
    private StackGenerator generator = new StackGenerator(true, false);

    public Stack transform(Assignment<ObjectMask> element) throws OutputWriteFailedException {
        AssignmentColorPool colorPool = this.colorPoolCreator.apply(element.numberPaired());
        StackProvider stackProvider = AssignmentGenerator.createTiledStackProvider(this.objectDrawer.createObjectsImage(element, true, colorPool), this.objectDrawer.createObjectsImage(element, false, colorPool), this.createLabel(element, true), this.createLabel(element, false));
        try {
            return this.generator.transform((Stack)stackProvider.get());
        }
        catch (ProvisionFailedException e) {
            throw new OutputWriteFailedException((Throwable)e);
        }
    }

    public StackWriteAttributes guaranteedImageAttributes() {
        return StackWriteAttributesFactory.rgbMaybe3D((boolean)false);
    }

    private static StackProvider createTiledStackProvider(Stack stackLeft, Stack stackRight, String nameLeft, String nameRight) {
        ArrayList<StackProviderWithLabel> listProvider = new ArrayList<StackProviderWithLabel>(2);
        listProvider.add(new StackProviderWithLabel(stackLeft, nameLeft));
        listProvider.add(new StackProviderWithLabel(stackRight, nameRight));
        return TileStackProviders.tile(listProvider, (int)2, (boolean)false, (boolean)true);
    }

    private String createLabel(Assignment<ObjectMask> assignment, boolean left) {
        String name = left ? (String)this.names._1() : (String)this.names._2();
        return AssignmentGenerator.maybeAppendUnassignedCount(this.appendUnassignedCount, name, assignment, true);
    }

    private static String maybeAppendUnassignedCount(boolean doAppend, String mainString, Assignment<ObjectMask> assignment, boolean left) {
        if (doAppend) {
            return String.format("%s (%d)", mainString, assignment.numberUnassigned(left));
        }
        return mainString;
    }

    @Generated
    public AssignmentGenerator(DrawColoredObjects objectDrawer, IntFunction<AssignmentColorPool> colorPoolCreator, Tuple2<String, String> names, boolean appendUnassignedCount) {
        this.objectDrawer = objectDrawer;
        this.colorPoolCreator = colorPoolCreator;
        this.names = names;
        this.appendUnassignedCount = appendUnassignedCount;
    }
}

