/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.annotation.io.assignment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.DoubleStream;
import lombok.Generated;
import org.anchoranalysis.annotation.io.assignment.Assignment;
import org.anchoranalysis.annotation.io.assignment.ObjectMaskPair;
import org.anchoranalysis.annotation.io.comparer.StatisticsToExport;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.Extent;

public class OverlappingObjects
implements Assignment<ObjectMask> {
    private List<ObjectMask> leftUnassigned = new ArrayList<ObjectMask>();
    private List<ObjectMask> rightUnassigned = new ArrayList<ObjectMask>();
    private List<ObjectMaskPair> pairs = new ArrayList<ObjectMaskPair>();

    public static OverlappingObjects createWithLeftUnassigned(ObjectCollection objects) {
        OverlappingObjects out = new OverlappingObjects();
        out.addUnassignedLeft(objects);
        return out;
    }

    public static OverlappingObjects createWithRight(ObjectCollection objects) {
        OverlappingObjects out = new OverlappingObjects();
        out.addUnassignedRight(objects);
        return out;
    }

    @Override
    public StatisticsToExport statistics() {
        StatisticsToExport out = new StatisticsToExport();
        out.addDouble("percentMatchesInAnnotation", this.percentLeftAssigned());
        out.addDouble("percentMatchesInResult", this.percentRightAssigned());
        out.addInt("matches", this.numberPaired());
        out.addInt("unmatchedAnnotation", this.numberUnassignedLeft());
        out.addInt("countItemsInAnnotation", this.leftSize());
        out.addInt("unmatchedResult", this.numberUnassignedRight());
        out.addInt("countItemsInResult", this.rightSize());
        out.addMeanExtrema("overlapFromPaired", this.meanOverlapFromPaired(), this.minOverlapFromPaired(), this.maxOverlapFromPaired());
        return out;
    }

    public void removeTouchingBorderXY(Extent extent) {
        OverlappingObjects.removeTouchingBorderXYObjects(extent, this.leftUnassigned);
        OverlappingObjects.removeTouchingBorderXYObjects(extent, this.rightUnassigned);
        OverlappingObjects.removeTouchingBorderXYPairObjects(extent, this.pairs);
    }

    @Override
    public List<ObjectMask> paired(boolean left) {
        return FunctionalList.mapToList(this.pairs, object -> object.getMultiplex(left));
    }

    @Override
    public List<ObjectMask> unassigned(boolean left) {
        if (left) {
            return this.leftUnassigned;
        }
        return this.rightUnassigned;
    }

    public double sumOverlapFromPaired() {
        double sum = 0.0;
        for (ObjectMaskPair pair : this.pairs) {
            sum += pair.getOverlapRatio();
        }
        return sum;
    }

    public void addUnassignedLeft(ObjectMask object) {
        this.leftUnassigned.add(object);
    }

    public void addUnassignedLeft(ObjectCollection objects) {
        this.leftUnassigned.addAll(objects.asList());
    }

    public void addUnassignedRight(ObjectMask object) {
        this.rightUnassigned.add(object);
    }

    public void addUnassignedRight(ObjectCollection objects) {
        this.rightUnassigned.addAll(objects.asList());
    }

    public void addAssignedPair(ObjectMask object1, ObjectMask object2, double overlapRatio) {
        this.pairs.add(new ObjectMaskPair(object1, object2, overlapRatio));
    }

    public double percentLeftAssigned() {
        int size = this.leftSize();
        if (size == 0) {
            return Double.NaN;
        }
        return (double)this.numberPaired() * 100.0 / (double)size;
    }

    public double percentRightAssigned() {
        int size = this.rightSize();
        if (size == 0) {
            return Double.NaN;
        }
        return (double)this.numberPaired() * 100.0 / (double)size;
    }

    @Override
    public int numberPaired() {
        return this.pairs.size();
    }

    @Override
    public int numberUnassigned(boolean left) {
        if (left) {
            return this.numberUnassignedLeft();
        }
        return this.numberUnassignedRight();
    }

    public int numberUnassignedLeft() {
        return this.leftUnassigned.size();
    }

    public int numberUnassignedRight() {
        return this.rightUnassigned.size();
    }

    public int leftSize() {
        return this.pairs.size() + this.leftUnassigned.size();
    }

    public int rightSize() {
        return this.pairs.size() + this.rightUnassigned.size();
    }

    private double meanOverlapFromPaired() {
        return this.sumOverlapFromPaired() / (double)this.pairs.size();
    }

    private double minOverlapFromPaired() {
        return this.pairsOverlapStream().min().orElse(Double.NaN);
    }

    private double maxOverlapFromPaired() {
        return this.pairsOverlapStream().max().orElse(Double.NaN);
    }

    private DoubleStream pairsOverlapStream() {
        return this.pairs.stream().mapToDouble(ObjectMaskPair::getOverlapRatio);
    }

    private static void removeTouchingBorderXYObjects(Extent extent, List<ObjectMask> list) {
        Iterator<ObjectMask> itr = list.iterator();
        while (itr.hasNext()) {
            if (!itr.next().boundingBox().atBorderXY(extent)) continue;
            itr.remove();
        }
    }

    private static void removeTouchingBorderXYPairObjects(Extent extent, List<ObjectMaskPair> list) {
        Iterator<ObjectMaskPair> itr = list.iterator();
        while (itr.hasNext()) {
            if (!itr.next().atBorderXY(extent)) continue;
            itr.remove();
        }
    }

    @Generated
    public List<ObjectMask> getLeftUnassigned() {
        return this.leftUnassigned;
    }

    @Generated
    public List<ObjectMask> getRightUnassigned() {
        return this.rightUnassigned;
    }
}

