/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.annotation.io.assignment;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.anchoranalysis.annotation.io.assignment.Assignment;
import org.anchoranalysis.annotation.io.comparer.StatisticsToExport;
import org.anchoranalysis.image.core.merge.ObjectMaskMerger;
import org.anchoranalysis.image.voxel.object.ObjectMask;

public class ObjectVoxelIntersection
implements Assignment<ObjectMask> {
    private final ObjectMask objectLeft;
    private final ObjectMask objectRight;
    private final int numberIntersectingVoxels;
    private final int numberUnionVoxels;
    private final int sizeLeft;
    private final int sizeRight;

    public ObjectVoxelIntersection(ObjectMask left, ObjectMask right) {
        this.objectLeft = left;
        this.objectRight = right;
        this.numberIntersectingVoxels = left.countIntersectingVoxels(right);
        this.numberUnionVoxels = ObjectMaskMerger.merge((ObjectMask)left, (ObjectMask)right).numberVoxelsOn();
        this.sizeLeft = left.numberVoxelsOn();
        this.sizeRight = right.numberVoxelsOn();
    }

    @Override
    public int numberPaired() {
        return this.isIntersectionPresent() ? 1 : 0;
    }

    @Override
    public int numberUnassigned(boolean left) {
        return this.isIntersectionPresent() ? 0 : 1;
    }

    @Override
    public List<ObjectMask> paired(boolean left) {
        return this.multiplexObjectIf(this.isIntersectionPresent(), left);
    }

    @Override
    public List<ObjectMask> unassigned(boolean left) {
        return this.multiplexObjectIf(!this.isIntersectionPresent(), left);
    }

    @Override
    public StatisticsToExport statistics() {
        StatisticsToExport out = new StatisticsToExport();
        out.addDouble("dice", this.calculateDice());
        out.addDouble("jaccard", this.calculateJaccard());
        out.addInt("numberIntersectingVoxels", this.numberIntersectingVoxels);
        out.addInt("numberUnionVoxels", this.numberUnionVoxels);
        out.addInt("sizeLeft", this.sizeLeft);
        out.addInt("sizeRight", this.sizeRight);
        return out;
    }

    private List<ObjectMask> multiplexObjectIf(boolean condition, boolean left) {
        if (condition) {
            return this.multiplexObject(left);
        }
        return Collections.emptyList();
    }

    private List<ObjectMask> multiplexObject(boolean left) {
        return Arrays.asList(left ? this.objectLeft : this.objectRight);
    }

    private boolean isIntersectionPresent() {
        return this.numberIntersectingVoxels > 0;
    }

    private double calculateDice() {
        int num = 2 * this.numberIntersectingVoxels;
        int dem = this.sizeLeft + this.sizeRight;
        return (double)num / (double)dem;
    }

    private double calculateJaccard() {
        return (double)this.numberIntersectingVoxels / (double)this.numberUnionVoxels;
    }
}

