/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.annotation.io.assignment;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.functional.checked.CheckedToDoubleBiFunction;

public final class CostMatrix<T> {
    private final List<T> first;
    private final List<T> second;
    private final double[][] matrix;

    public static <T> CostMatrix<T> create(List<T> first, List<T> second, boolean symmetric, CheckedToDoubleBiFunction<T, T, CreateException> costCalculator) throws CreateException {
        if (first.isEmpty()) {
            throw new CreateException("first must be non-empty");
        }
        if (second.isEmpty()) {
            throw new CreateException("second must be non-empty");
        }
        double[][] costs = new double[first.size()][second.size()];
        for (int i = 0; i < first.size(); ++i) {
            T firstElement = first.get(i);
            for (int j = 0; j < CostMatrix.selectInnerUpperBound(i, second.size(), symmetric); ++j) {
                T secondElement = second.get(j);
                double cost = costCalculator.applyAsDouble(firstElement, secondElement);
                CostMatrix.putCostInMatrix(costs, i, j, cost, symmetric);
                if (!Double.isNaN(cost)) continue;
                throw new CreateException("Distance is NaN. This is not allowed.");
            }
        }
        return new CostMatrix<T>(first, second, costs);
    }

    public double getCost(int index1, int index2) {
        return this.matrix[index1][index2];
    }

    public int sizeFirst() {
        return this.first.size();
    }

    public int sizeSecond() {
        return this.second.size();
    }

    private static void putCostInMatrix(double[][] costs, int index1, int index2, double cost, boolean symmetric) {
        costs[index1][index2] = cost;
        if (symmetric) {
            costs[index2][index1] = cost;
        }
    }

    private static int selectInnerUpperBound(int iterationFirst, int sizeSecond, boolean symmetric) {
        if (symmetric) {
            return iterationFirst;
        }
        return sizeSecond;
    }

    @Generated
    public List<T> getFirst() {
        return this.first;
    }

    @Generated
    public List<T> getSecond() {
        return this.second;
    }

    @Generated
    public double[][] getMatrix() {
        return this.matrix;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CostMatrix)) {
            return false;
        }
        CostMatrix other = (CostMatrix)o;
        List<T> this$first = this.getFirst();
        List<T> other$first = other.getFirst();
        if (this$first == null ? other$first != null : !((Object)this$first).equals(other$first)) {
            return false;
        }
        List<T> this$second = this.getSecond();
        List<T> other$second = other.getSecond();
        if (this$second == null ? other$second != null : !((Object)this$second).equals(other$second)) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getMatrix(), (Object[])other.getMatrix());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<T> $first = this.getFirst();
        result = result * 59 + ($first == null ? 43 : ((Object)$first).hashCode());
        List<T> $second = this.getSecond();
        result = result * 59 + ($second == null ? 43 : ((Object)$second).hashCode());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getMatrix());
        return result;
    }

    @Generated
    public String toString() {
        return "CostMatrix(first=" + String.valueOf(this.getFirst()) + ", second=" + String.valueOf(this.getSecond()) + ", matrix=" + Arrays.deepToString((Object[])this.getMatrix()) + ")";
    }

    @Generated
    private CostMatrix(List<T> first, List<T> second, double[][] matrix) {
        this.first = first;
        this.second = second;
        this.matrix = matrix;
    }
}

