/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.annotation.io;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.annotation.io.bean.AnnotatorStrategy;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.core.stack.named.NamedStacksSupplier;
import org.anchoranalysis.image.io.stack.input.ProvidesStackInput;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.InputFromManagerDelegate;

public class AnnotationWithStrategy<T extends AnnotatorStrategy>
extends InputFromManagerDelegate<ProvidesStackInput> {
    private final T strategy;
    private final Path path;

    public AnnotationWithStrategy(ProvidesStackInput input, T strategy) throws OperationFailedException {
        super((InputFromManager)input);
        this.strategy = strategy;
        this.path = ((AnnotatorStrategy)((Object)strategy)).pathFor(input);
    }

    public Optional<File> associatedFile() {
        return ((ProvidesStackInput)this.getDelegate()).pathForBinding().map(Path::toFile);
    }

    public Optional<String> label(OperationContext context) throws OperationFailedException {
        return ((AnnotatorStrategy)((Object)this.strategy)).annotationLabelFor((ProvidesStackInput)this.getDelegate(), context);
    }

    public NamedStacksSupplier stacks(Logger logger) {
        return NamedStacksSupplier.cache(() -> ((ProvidesStackInput)this.getDelegate()).asSet(logger));
    }

    @Generated
    public T getStrategy() {
        return this.strategy;
    }

    @Generated
    public Path getPath() {
        return this.path;
    }
}

