/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.annotation.io.comparer;

import java.util.Arrays;
import java.util.List;
import org.anchoranalysis.core.value.TypedValue;
import org.anchoranalysis.math.arithmetic.RunningSumExtrema;
import org.apache.commons.lang.StringUtils;

public class StatisticsToExport {
    private static final int DECIMAL_PLACES = 4;
    List<String> names = Arrays.asList(new String[0]);
    List<TypedValue> values = Arrays.asList(new TypedValue[0]);

    public void append(StatisticsToExport toAppend) {
        this.names.addAll(toAppend.names);
        this.values.addAll(toAppend.values);
    }

    public void addString(String name, String value) {
        this.add(name, new TypedValue(value));
    }

    public void addDouble(String name, double value) {
        this.add(name, new TypedValue(value, 4));
    }

    public void addInt(String name, int value) {
        this.add(name, new TypedValue(value));
    }

    public void addMeanExtrema(String name, double mean, double min, double max) {
        String nameCapitalized = StringUtils.capitalize((String)name);
        this.addDouble("mean" + nameCapitalized, mean);
        this.addDouble("min" + nameCapitalized, min);
        this.addDouble("max" + nameCapitalized, max);
    }

    public void addMeanExtrema(String name, RunningSumExtrema runningSum) {
        this.addMeanExtrema(name, runningSum.mean(), runningSum.min(), runningSum.max());
    }

    private void add(String name, TypedValue value) {
        this.names.add(name);
        this.values.add(value);
    }

    public List<String> getNames() {
        return this.names;
    }

    public List<TypedValue> getValues() {
        return this.values;
    }
}

