/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.annotation.io.assignment.generator;

import java.util.Collection;
import java.util.List;
import org.anchoranalysis.annotation.io.assignment.Assignment;
import org.anchoranalysis.annotation.io.assignment.generator.AssignmentColorPool;
import org.anchoranalysis.core.color.ColorIndex;
import org.anchoranalysis.core.color.ColorList;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.object.properties.ObjectCollectionWithProperties;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.bean.object.draw.Filled;
import org.anchoranalysis.image.io.bean.object.draw.IfElse;
import org.anchoranalysis.image.io.bean.object.draw.Outline;
import org.anchoranalysis.image.io.object.output.rgb.DrawObjectsGenerator;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.overlay.bean.DrawObject;

public class DrawColoredObjects {
    private final DisplayStack background;
    private final boolean flatten;
    private final int outlineWidth;

    public Stack createObjectsImage(Assignment<ObjectMask> assignment, boolean left, AssignmentColorPool colorPool) throws OutputWriteFailedException {
        try {
            return this.createObjectsImage(assignment.paired(left), colorPool, assignment.unassigned(left));
        }
        catch (OperationFailedException e) {
            throw new OutputWriteFailedException((Throwable)e);
        }
    }

    private Stack createObjectsImage(List<ObjectMask> matchedObjects, AssignmentColorPool colorPool, List<ObjectMask> otherObjects) throws OutputWriteFailedException, OperationFailedException {
        ObjectCollection objects = ObjectCollectionFactory.of((Collection[])new Collection[]{matchedObjects, otherObjects});
        DrawObjectsGenerator drawObjects = this.createGenerator(otherObjects, colorPool.createColors(otherObjects.size()), colorPool.isDifferentColorsForPairs());
        return drawObjects.transform(new ObjectCollectionWithProperties(objects));
    }

    private DrawObjectsGenerator createGenerator(List<ObjectMask> otherObjects, ColorList colors, boolean differentColorsForMatches) {
        Outline outlineWriter = new Outline(this.outlineWidth, !this.flatten);
        if (differentColorsForMatches) {
            DrawObject conditionalWriter = DrawColoredObjects.createConditionalWriter(otherObjects, (DrawObject)outlineWriter);
            return this.createGenerator(conditionalWriter, colors);
        }
        return this.createGenerator((DrawObject)outlineWriter, colors);
    }

    private DrawObjectsGenerator createGenerator(DrawObject drawObject, ColorList colors) {
        return DrawObjectsGenerator.withBackgroundAndColors((DrawObject)drawObject, (DisplayStack)this.background, (ColorIndex)colors);
    }

    private static DrawObject createConditionalWriter(List<ObjectMask> otherObjects, DrawObject writer) {
        return new IfElse((object, stack, id) -> otherObjects.contains(object.asObjectMask()), writer, (DrawObject)new Filled());
    }

    public DrawColoredObjects(DisplayStack background, boolean flatten, int outlineWidth) {
        this.background = background;
        this.flatten = flatten;
        this.outlineWidth = outlineWidth;
    }
}

