/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.annotation.io.assignment.generator;

import org.anchoranalysis.bean.shared.color.scheme.ColorScheme;
import org.anchoranalysis.bean.shared.color.scheme.VeryBright;
import org.anchoranalysis.core.color.ColorList;
import org.anchoranalysis.core.color.RGBColor;
import org.anchoranalysis.core.exception.OperationFailedException;

public class AssignmentColorPool {
    private final int numberPaired;
    private final ColorScheme colorSchemePaired;
    private final ColorScheme colorSchemeUnpaired;
    private final boolean differentColorsForPairs;

    public AssignmentColorPool(int numberPaired, ColorScheme colorSchemePaired) {
        this(numberPaired, colorSchemePaired, (ColorScheme)new VeryBright(), true);
    }

    public ColorList createColors(int numberUnpaired) throws OperationFailedException {
        ColorList colors = new ColorList();
        if (this.differentColorsForPairs) {
            AssignmentColorPool.addAllScaled(colors, this.colorSchemePaired.createList(this.numberPaired), 0.5);
            colors.addAll(this.colorSchemeUnpaired.createList(numberUnpaired));
        } else {
            colors.addAll(this.colorSchemeUnpaired.createList(this.numberPaired + numberUnpaired));
        }
        return colors;
    }

    private static void addAllScaled(ColorList destination, ColorList toAdd, double scale) {
        for (RGBColor color : toAdd) {
            RGBColor scaled = new RGBColor((int)((double)color.getRed() * scale), (int)((double)color.getGreen() * scale), (int)((double)color.getBlue() * scale));
            destination.add(scaled);
        }
    }

    public AssignmentColorPool(int numberPaired, ColorScheme colorSchemePaired, ColorScheme colorSchemeUnpaired, boolean differentColorsForPairs) {
        this.numberPaired = numberPaired;
        this.colorSchemePaired = colorSchemePaired;
        this.colorSchemeUnpaired = colorSchemeUnpaired;
        this.differentColorsForPairs = differentColorsForPairs;
    }

    public boolean isDifferentColorsForPairs() {
        return this.differentColorsForPairs;
    }
}

