/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.annotation.io.assignment;

import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.Extent;

final class ObjectMaskPair {
    private final ObjectMask left;
    private final ObjectMask right;
    private final double overlapRatio;

    public boolean atBorderXY(Extent extent) {
        return this.left.boundingBox().atBorderXY(extent) || this.right.boundingBox().atBorderXY(extent);
    }

    public ObjectMask getMultiplex(boolean leftFlag) {
        return leftFlag ? this.left : this.right;
    }

    public ObjectMask getLeft() {
        return this.left;
    }

    public ObjectMask getRight() {
        return this.right;
    }

    public double getOverlapRatio() {
        return this.overlapRatio;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectMaskPair)) {
            return false;
        }
        ObjectMaskPair other = (ObjectMaskPair)o;
        if (Double.compare(this.getOverlapRatio(), other.getOverlapRatio()) != 0) {
            return false;
        }
        ObjectMask this$left = this.getLeft();
        ObjectMask other$left = other.getLeft();
        if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
            return false;
        }
        ObjectMask this$right = this.getRight();
        ObjectMask other$right = other.getRight();
        return !(this$right == null ? other$right != null : !this$right.equals(other$right));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $overlapRatio = Double.doubleToLongBits(this.getOverlapRatio());
        result = result * 59 + (int)($overlapRatio >>> 32 ^ $overlapRatio);
        ObjectMask $left = this.getLeft();
        result = result * 59 + ($left == null ? 43 : $left.hashCode());
        ObjectMask $right = this.getRight();
        result = result * 59 + ($right == null ? 43 : $right.hashCode());
        return result;
    }

    public String toString() {
        return "ObjectMaskPair(left=" + this.getLeft() + ", right=" + this.getRight() + ", overlapRatio=" + this.getOverlapRatio() + ")";
    }

    public ObjectMaskPair(ObjectMask left, ObjectMask right, double overlapRatio) {
        this.left = left;
        this.right = right;
        this.overlapRatio = overlapRatio;
    }
}

