/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.annotation.io.assignment;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.anchoranalysis.annotation.io.assignment.CostMatrix;
import org.anchoranalysis.annotation.io.assignment.OverlappingObjects;
import org.anchoranalysis.image.voxel.object.ObjectMask;

class CreateAssignmentFromCostMatrix {
    private CostMatrix<ObjectMask> costMatrix;
    private int[] assign;
    private double maxAcceptedCost;

    public OverlappingObjects createAssignment() {
        OverlappingObjects assignment = new OverlappingObjects();
        List<ObjectMask> left = this.costMatrix.getFirst();
        List<ObjectMask> right = this.costMatrix.getSecond();
        Set<Integer> setAnnotationObjects = CreateAssignmentFromCostMatrix.setForRange(left.size());
        Set<Integer> setResultObjects = CreateAssignmentFromCostMatrix.setForRange(right.size());
        this.addPairsToAssignment(assignment, left, right, setAnnotationObjects, setResultObjects);
        CreateAssignmentFromCostMatrix.addObjectsFromIndices(left, setAnnotationObjects, assignment::addUnassignedLeft);
        CreateAssignmentFromCostMatrix.addObjectsFromIndices(right, setResultObjects, assignment::addUnassignedRight);
        return assignment;
    }

    private void addPairsToAssignment(OverlappingObjects assignment, List<ObjectMask> left, List<ObjectMask> right, Set<Integer> setLeft, Set<Integer> setRight) {
        for (int i = 0; i < this.assign.length; ++i) {
            double cost;
            int ref = this.assign[i];
            if (ref == -1 || !((cost = this.costMatrix.getCost(i, ref)) < this.maxAcceptedCost)) continue;
            assignment.addAssignedPair(left.get(i), right.get(ref), 1.0 - cost);
            setLeft.remove(i);
            setRight.remove(ref);
        }
    }

    private static Set<Integer> setForRange(int endValueExclusive) {
        return IntStream.range(0, endValueExclusive).boxed().collect(Collectors.toSet());
    }

    private static void addObjectsFromIndices(List<ObjectMask> objects, Set<Integer> indices, Consumer<ObjectMask> functionToAdd) {
        indices.forEach(index -> functionToAdd.accept((ObjectMask)objects.get((int)index)));
    }

    public CreateAssignmentFromCostMatrix(CostMatrix<ObjectMask> costMatrix, int[] assign, double maxAcceptedCost) {
        this.costMatrix = costMatrix;
        this.assign = assign;
        this.maxAcceptedCost = maxAcceptedCost;
    }
}

