/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.annotation.io.assignment;

import org.anchoranalysis.annotation.io.assignment.CostMatrix;
import org.anchoranalysis.annotation.io.assignment.CreateAssignmentFromCostMatrix;
import org.anchoranalysis.annotation.io.assignment.OverlappingObjects;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.feature.bean.evaluator.FeatureEvaluator;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.math.optimization.HungarianAlgorithm;

public class AssignOverlappingObjects {
    private final FeatureEvaluator<FeatureInputPairObjects> featureEvaluator;
    private final boolean flatten;
    private CostMatrix<ObjectMask> costs;

    public OverlappingObjects createAssignment(ObjectCollection left, ObjectCollection right, double maxAcceptedCost, Dimensions dimensions) throws FeatureCalculationException {
        if (left.isEmpty()) {
            return OverlappingObjects.createWithRight(right);
        }
        if (right.isEmpty()) {
            return OverlappingObjects.createWithLeftUnassigned(left);
        }
        this.costs = this.createCostMatrix(this.maybeProject(left), this.maybeProject(right), dimensions);
        OverlappingObjects assignment = AssignOverlappingObjects.findMinimalCostMapping(this.costs, maxAcceptedCost);
        if (assignment.rightSize() != right.size()) {
            throw new AnchorImpossibleSituationException("assignment.rightSize() does not equal the number of the right objects. This should never happen!");
        }
        return assignment;
    }

    private ObjectCollection maybeProject(ObjectCollection objects) {
        if (this.flatten) {
            return objects.stream().map(ObjectMask::flattenZ);
        }
        return objects;
    }

    private CostMatrix<ObjectMask> createCostMatrix(ObjectCollection annotation, ObjectCollection result, Dimensions dimensions) throws FeatureCalculationException {
        try {
            FeatureCalculatorSingle calculator = this.featureEvaluator.createFeatureSession();
            EnergyStack energyStack = new EnergyStack(dimensions);
            return CostMatrix.create(annotation.asList(), result.asList(), false, (first, second) -> {
                try {
                    FeatureInputPairObjects input = new FeatureInputPairObjects(first, second, energyStack);
                    return calculator.calculate((FeatureInput)input);
                }
                catch (FeatureCalculationException e) {
                    throw new CreateException((Throwable)e);
                }
            });
        }
        catch (CreateException | OperationFailedException e) {
            throw new FeatureCalculationException(e);
        }
    }

    private static OverlappingObjects findMinimalCostMapping(CostMatrix<ObjectMask> costs, double maxAcceptedCost) {
        HungarianAlgorithm hungarian = new HungarianAlgorithm(costs.getMatrix());
        int[] assign = hungarian.execute();
        return new CreateAssignmentFromCostMatrix(costs, assign, maxAcceptedCost).createAssignment();
    }

    public AssignOverlappingObjects(FeatureEvaluator<FeatureInputPairObjects> featureEvaluator, boolean flatten) {
        this.featureEvaluator = featureEvaluator;
        this.flatten = flatten;
    }

    public CostMatrix<ObjectMask> getCosts() {
        return this.costs;
    }
}

