package org.anarres.graphviz.parser.analysis;

import java.util.*;
import org.anarres.graphviz.parser.node.*;

public class CloneVisitor extends AnalysisAdapter {

    private Object clone;

    private <T extends Node> List<T> clone(List<T> in) {
        if (in == null)
            return null;
        List<T> out = new ArrayList<T>(in.size());
        for (T node : in)
            out.add(clone(node));
        return out;
    }

    @SuppressWarnings({"unchecked"})
    public <T extends Node> T clone(T node) {
        if (node == null)
            return null;
        node.apply(this);
        return (T) clone;
    }

    private <T extends Node> void setClone(T prev, T repl) {
        this.clone = repl;
        fireClone(prev, repl);
    }

    protected <T extends Node> void fireClone(T prev, T repl) {
    }

    @Override
    public void defaultCase(Node node) {
        throw new IllegalStateException();
    }

    @Override
    public void caseTKwEdge(TKwEdge node) {
        setClone(node, (TKwEdge) node.clone());
    }

    @Override
    public void caseALinkEdge(ALinkEdge node) {
        TTokLink _TokLink_ = clone(node.getTokLink());
        setClone(node, new ALinkEdge(_TokLink_));
    }

    @Override
    public void caseTKwNode(TKwNode node) {
        setClone(node, (TKwNode) node.clone());
    }

    @Override
    public void caseTBlank(TBlank node) {
        setClone(node, (TBlank) node.clone());
    }

    @Override
    public void caseASimpleNode(ASimpleNode node) {
        PAtom _Name_ = clone(node.getName());
        setClone(node, new ASimpleNode(_Name_));
    }

    @Override
    public void caseEOF(EOF node) {
        setClone(node, new EOF());
    }

    @Override
    public void caseADigraphGraphType(ADigraphGraphType node) {
        TKwDigraph _KwDigraph_ = clone(node.getKwDigraph());
        setClone(node, new ADigraphGraphType(_KwDigraph_));
    }

    @Override
    public void caseTTokLbrace(TTokLbrace node) {
        setClone(node, (TTokLbrace) node.clone());
    }

    @Override
    public void caseTTokRsquare(TTokRsquare node) {
        setClone(node, (TTokRsquare) node.clone());
    }

    @Override
    public void caseAEdgeDefaultsStatement(AEdgeDefaultsStatement node) {
        setClone(node, new AEdgeDefaultsStatement());
    }

    @Override
    public void caseTStringLiteral(TStringLiteral node) {
        setClone(node, (TStringLiteral) node.clone());
    }

    @Override
    public void caseTKwGraph(TKwGraph node) {
        setClone(node, (TKwGraph) node.clone());
    }

    @Override
    public void caseTKwDigraph(TKwDigraph node) {
        setClone(node, (TKwDigraph) node.clone());
    }

    @Override
    public void caseAAttribute(AAttribute node) {
        PAtom _Key_ = clone(node.getKey());
        PAtom _Value_ = clone(node.getValue());
        setClone(node, new AAttribute(_Key_, _Value_));
    }

    @Override
    public void caseTTokLink(TTokLink node) {
        setClone(node, (TTokLink) node.clone());
    }

    @Override
    public void caseTTokComma(TTokComma node) {
        setClone(node, (TTokComma) node.clone());
    }

    @Override
    public void caseANodeDefaultsStatement(ANodeDefaultsStatement node) {
        setClone(node, new ANodeDefaultsStatement());
    }

    @Override
    public void caseTLiteral(TLiteral node) {
        setClone(node, (TLiteral) node.clone());
    }

    @Override
    public void caseTTokEq(TTokEq node) {
        setClone(node, (TTokEq) node.clone());
    }

    @Override
    public void caseAGraphDefaultsStatement(AGraphDefaultsStatement node) {
        setClone(node, new AGraphDefaultsStatement());
    }

    @Override
    public void caseADataStatement(ADataStatement node) {
        setClone(node, new ADataStatement());
    }

    @Override
    public void caseAGraph(AGraph node) {
        PGraphType _GraphType_ = clone(node.getGraphType());
        PAtom _Name_ = clone(node.getName());
        List<PStatement> _Statement_ = clone(node.getStatement());
        setClone(node, new AGraph(_GraphType_, _Name_, _Statement_));
    }

    @Override
    public void caseAQuotedAtom(AQuotedAtom node) {
        TStringLiteral _StringLiteral_ = clone(node.getStringLiteral());
        setClone(node, new AQuotedAtom(_StringLiteral_));
    }

    @Override
    public void caseAArrowEdge(AArrowEdge node) {
        TTokArrow _TokArrow_ = clone(node.getTokArrow());
        setClone(node, new AArrowEdge(_TokArrow_));
    }

    @Override
    public void caseTComment(TComment node) {
        setClone(node, (TComment) node.clone());
    }

    @Override
    public void caseAPortNode(APortNode node) {
        PAtom _Name_ = clone(node.getName());
        PAtom _Port_ = clone(node.getPort());
        setClone(node, new APortNode(_Name_, _Port_));
    }

    @Override
    public void caseASubgraphNode(ASubgraphNode node) {
        PAtom _Name_ = clone(node.getName());
        List<PStatement> _Statement_ = clone(node.getStatement());
        setClone(node, new ASubgraphNode(_Name_, _Statement_));
    }

    @Override
    public void caseTKwSubgraph(TKwSubgraph node) {
        setClone(node, (TKwSubgraph) node.clone());
    }

    @Override
    public void caseTTokColon(TTokColon node) {
        setClone(node, (TTokColon) node.clone());
    }

    @Override
    public void caseALiteralAtom(ALiteralAtom node) {
        TLiteral _Literal_ = clone(node.getLiteral());
        setClone(node, new ALiteralAtom(_Literal_));
    }

    @Override
    public void caseAGlobalDefaultsStatement(AGlobalDefaultsStatement node) {
        setClone(node, new AGlobalDefaultsStatement());
    }

    @Override
    public void caseTTokLsquare(TTokLsquare node) {
        setClone(node, (TTokLsquare) node.clone());
    }

    @Override
    public void caseAComposite(AComposite node) {
        List<PNode> _Node_ = clone(node.getNode());
        List<PAttribute> _Attribute_ = clone(node.getAttribute());
        setClone(node, new AComposite(_Node_, _Attribute_));
    }

    @Override
    public void caseTTokArrow(TTokArrow node) {
        setClone(node, (TTokArrow) node.clone());
    }

    @Override
    public void caseTTokSemi(TTokSemi node) {
        setClone(node, (TTokSemi) node.clone());
    }

    @Override
    public void caseAGraphGraphType(AGraphGraphType node) {
        TKwGraph _KwGraph_ = clone(node.getKwGraph());
        setClone(node, new AGraphGraphType(_KwGraph_));
    }

    @Override
    public void caseTKwStrict(TKwStrict node) {
        setClone(node, (TKwStrict) node.clone());
    }

    @Override
    public void caseTTokRbrace(TTokRbrace node) {
        setClone(node, (TTokRbrace) node.clone());
    }

    @Override
    public void caseStart(Start node) {
        PGraph _PGraph_ = clone(node.getPGraph());
        EOF _EOF_ = clone(node.getEOF());
        setClone(node, new Start(_PGraph_, _EOF_));
    }
}
