/* This file was generated by SableCC (http://www.sablecc.org/). */

package org.anarres.graphviz.parser.lexer;

import java.io.*;
import org.anarres.graphviz.parser.node.*;

@SuppressWarnings("nls")
public class Lexer implements LexerInterface
{
    protected Token token;
    protected State state = State.INITIAL;

    private PushbackReader in;
    private int offset;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuilder text = new StringBuilder();

    @SuppressWarnings("unused")
    protected void filter() throws LexerException, IOException
    {
        // Do nothing
    }

    public Lexer(@SuppressWarnings("hiding") PushbackReader in)
    {
        this.in = in;
    }
 
    public Token peek() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.token = getToken();
            filter();
        }

        return this.token;
    }

    public Token next() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.token = getToken();
            filter();
        }

        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_offset = this.offset;
        int start_pos = this.pos;
        int start_line = this.line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_offset = -1;
        int accept_pos = -1;
        int accept_line = -1;

        @SuppressWarnings("hiding") int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
        @SuppressWarnings("hiding") int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(this.cr)
                    {
                        this.cr = false;
                    }
                    else
                    {
                this.offset++;
                        this.line++;
                        this.pos = 0;
                    }
                    break;
                case 13:
                this.offset++;
                    this.line++;
                    this.pos = 0;
                    this.cr = true;
                    break;
                default:
                this.offset++;
                    this.pos++;
                    this.cr = false;
                    break;
                }

                this.text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = this.text.length();
            accept_offset = this.offset;
                    accept_pos = this.pos;
                    accept_line = this.line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                            @SuppressWarnings("hiding") Token token = new0(
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 1:
                        {
                            @SuppressWarnings("hiding") Token token = new1(
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 2:
                        {
                            @SuppressWarnings("hiding") Token token = new2(
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 3:
                        {
                            @SuppressWarnings("hiding") Token token = new3(
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 4:
                        {
                            @SuppressWarnings("hiding") Token token = new4(
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 5:
                        {
                            @SuppressWarnings("hiding") Token token = new5(
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 6:
                        {
                            @SuppressWarnings("hiding") Token token = new6(
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 7:
                        {
                            @SuppressWarnings("hiding") Token token = new7(
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 8:
                        {
                            @SuppressWarnings("hiding") Token token = new8(
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 9:
                        {
                            @SuppressWarnings("hiding") Token token = new9(
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 10:
                        {
                            @SuppressWarnings("hiding") Token token = new10(
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 11:
                        {
                            @SuppressWarnings("hiding") Token token = new11(
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 12:
                        {
                            @SuppressWarnings("hiding") Token token = new12(
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 13:
                        {
                            @SuppressWarnings("hiding") Token token = new13(
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 14:
                        {
                            @SuppressWarnings("hiding") Token token = new14(
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 15:
                        {
                            @SuppressWarnings("hiding") Token token = new15(
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 16:
                        {
                            @SuppressWarnings("hiding") Token token = new16(
                                getText(accept_length),
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 17:
                        {
                            @SuppressWarnings("hiding") Token token = new17(
                                getText(accept_length),
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 18:
                        {
                            @SuppressWarnings("hiding") Token token = new18(
                                getText(accept_length),
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 19:
                        {
                            @SuppressWarnings("hiding") Token token = new19(
                                getText(accept_length),
                    start_offset,
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
            this.offset = accept_offset;
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(this.text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + this.text);
                    }

                    @SuppressWarnings("hiding") EOF token = new EOF(
                    start_offset,
                        start_line + 1,
                        start_pos + 1);
                    return token;
                }
            }
        }
    }

    Token new0(@SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTokLbrace(offset, line, pos); }
    Token new1(@SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTokRbrace(offset, line, pos); }
    Token new2(@SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTokLsquare(offset, line, pos); }
    Token new3(@SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTokRsquare(offset, line, pos); }
    Token new4(@SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTokArrow(offset, line, pos); }
    Token new5(@SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTokLink(offset, line, pos); }
    Token new6(@SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTokEq(offset, line, pos); }
    Token new7(@SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTokSemi(offset, line, pos); }
    Token new8(@SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTokComma(offset, line, pos); }
    Token new9(@SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTokColon(offset, line, pos); }
    Token new10(@SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TKwStrict(offset, line, pos); }
    Token new11(@SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TKwGraph(offset, line, pos); }
    Token new12(@SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TKwDigraph(offset, line, pos); }
    Token new13(@SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TKwSubgraph(offset, line, pos); }
    Token new14(@SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TKwNode(offset, line, pos); }
    Token new15(@SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TKwEdge(offset, line, pos); }
    Token new16(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLiteral(text, offset, line, pos); }
    Token new17(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TStringLiteral(text, offset, line, pos); }
    Token new18(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TBlank(text, offset, line, pos); }
    Token new19(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int offset, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TComment(text, offset, line, pos); }

    private int getChar() throws IOException
    {
        if(this.eof)
        {
            return -1;
        }

        int result = this.in.read();

        if(result == -1)
        {
            this.eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = this.text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            this.eof = false;

            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(@SuppressWarnings("hiding") Token token) throws IOException
    {
        @SuppressWarnings("hiding") String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            this.eof = false;

            this.in.unread(text.charAt(i));
        }

        this.offset = token.getOffset();
        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

protected String getText(int acceptLength) { return text.substring(0, acceptLength); }

    private static int[][][][] gotoTable;
/*  {
        { // INITIAL
            {{9, 9, 1}, {10, 10, 2}, {13, 13, 3}, {32, 32, 4}, {34, 34, 5}, {35, 35, 6}, {44, 44, 7}, {45, 45, 8}, {46, 46, 9}, {47, 47, 10}, {48, 57, 11}, {58, 58, 12}, {59, 59, 13}, {61, 61, 14}, {65, 90, 15}, {91, 91, 16}, {93, 93, 17}, {95, 95, 15}, {97, 99, 15}, {100, 100, 18}, {101, 101, 19}, {102, 102, 15}, {103, 103, 20}, {104, 109, 15}, {110, 110, 21}, {111, 114, 15}, {115, 115, 22}, {116, 122, 15}, {123, 123, 23}, {125, 125, 24}, },
            {{9, 32, -2}, },
            {{9, 32, -2}, },
            {{9, 9, 1}, {10, 10, 25}, {13, 32, -2}, },
            {{9, 32, -2}, },
            {{0, 9, 26}, {11, 12, 26}, {14, 33, 26}, {34, 34, 27}, {35, 91, 26}, {92, 92, 28}, {93, 65535, 26}, },
            {{0, 9, 29}, {10, 10, 30}, {11, 12, 29}, {13, 13, 31}, {14, 65535, 29}, },
            {},
            {{45, 45, 32}, {62, 62, 33}, },
            {{46, 46, 9}, {48, 57, 11}, {65, 90, 15}, {95, 95, 15}, {97, 122, 15}, },
            {{42, 42, 34}, {47, 47, 35}, },
            {{46, 122, -11}, },
            {},
            {},
            {},
            {{46, 122, -11}, },
            {},
            {},
            {{46, 95, -11}, {97, 104, 15}, {105, 105, 36}, {106, 122, 15}, },
            {{46, 95, -11}, {97, 99, 15}, {100, 100, 37}, {101, 122, 15}, },
            {{46, 95, -11}, {97, 113, 15}, {114, 114, 38}, {115, 122, 15}, },
            {{46, 95, -11}, {97, 110, 15}, {111, 111, 39}, {112, 122, 15}, },
            {{46, 95, -11}, {97, 115, 15}, {116, 116, 40}, {117, 117, 41}, {118, 122, 15}, },
            {},
            {},
            {{9, 32, -2}, },
            {{0, 65535, -7}, },
            {},
            {{34, 34, 42}, {39, 39, 43}, {63, 63, 44}, {92, 92, 45}, {97, 97, 46}, {98, 98, 47}, {102, 102, 48}, {108, 108, 49}, {110, 110, 50}, {114, 114, 51}, {116, 116, 52}, {118, 118, 53}, },
            {{0, 65535, -8}, },
            {},
            {{10, 10, 54}, },
            {},
            {},
            {{0, 41, 55}, {42, 42, 56}, {43, 65535, 55}, },
            {{0, 9, 57}, {10, 10, 58}, {11, 12, 57}, {13, 13, 59}, {14, 65535, 57}, },
            {{46, 95, -11}, {97, 102, 15}, {103, 103, 60}, {104, 122, 15}, },
            {{46, 102, -38}, {103, 103, 61}, {104, 122, 15}, },
            {{46, 95, -11}, {97, 97, 62}, {98, 122, 15}, },
            {{46, 99, -21}, {100, 100, 63}, {101, 122, 15}, },
            {{46, 113, -22}, {114, 114, 64}, {115, 122, 15}, },
            {{46, 95, -11}, {97, 97, 15}, {98, 98, 65}, {99, 122, 15}, },
            {{0, 65535, -7}, },
            {{0, 65535, -7}, },
            {{0, 65535, -7}, },
            {{0, 65535, -7}, },
            {{0, 65535, -7}, },
            {{0, 65535, -7}, },
            {{0, 65535, -7}, },
            {{0, 65535, -7}, },
            {{0, 65535, -7}, },
            {{0, 65535, -7}, },
            {{0, 65535, -7}, },
            {{0, 65535, -7}, },
            {},
            {{0, 65535, -36}, },
            {{0, 41, 66}, {42, 42, 56}, {43, 46, 66}, {47, 47, 67}, {48, 65535, 66}, },
            {{0, 65535, -37}, },
            {},
            {{10, 10, 68}, },
            {{46, 113, -22}, {114, 114, 69}, {115, 122, 15}, },
            {{46, 95, -11}, {97, 100, 15}, {101, 101, 70}, {102, 122, 15}, },
            {{46, 95, -11}, {97, 111, 15}, {112, 112, 71}, {113, 122, 15}, },
            {{46, 100, -63}, {101, 101, 72}, {102, 122, 15}, },
            {{46, 104, -20}, {105, 105, 73}, {106, 122, 15}, },
            {{46, 102, -38}, {103, 103, 74}, {104, 122, 15}, },
            {{0, 41, 75}, {42, 42, 76}, {43, 65535, 75}, },
            {},
            {},
            {{46, 95, -11}, {97, 97, 77}, {98, 122, 15}, },
            {{46, 122, -11}, },
            {{46, 95, -11}, {97, 103, 15}, {104, 104, 78}, {105, 122, 15}, },
            {{46, 122, -11}, },
            {{46, 95, -11}, {97, 98, 15}, {99, 99, 79}, {100, 122, 15}, },
            {{46, 113, -22}, {114, 114, 80}, {115, 122, 15}, },
            {{0, 65535, -68}, },
            {{0, 41, 66}, {42, 42, 76}, {43, 65535, -58}, },
            {{46, 111, -64}, {112, 112, 81}, {113, 122, 15}, },
            {{46, 122, -11}, },
            {{46, 115, -24}, {116, 116, 82}, {117, 122, 15}, },
            {{46, 95, -11}, {97, 97, 83}, {98, 122, 15}, },
            {{46, 103, -73}, {104, 104, 84}, {105, 122, 15}, },
            {{46, 122, -11}, },
            {{46, 111, -64}, {112, 112, 85}, {113, 122, 15}, },
            {{46, 122, -11}, },
            {{46, 103, -73}, {104, 104, 86}, {105, 122, 15}, },
            {{46, 122, -11}, },
        }
    };*/

    private static int[][] accept;
/*  {
        // INITIAL
        {16, 18, 18, 18, 18, -1, 19, 8, -1, 16, -1, 16, 9, 7, 6, 16, 2, 3, 16, 16, 16, 16, 16, 0, 1, 18, -1, 17, -1, 19, 19, 19, 5, 4, -1, 19, 16, 16, 16, 16, 16, 16, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 19, -1, -1, 19, 19, 19, 16, 16, 16, 16, 16, 16, -1, 19, 19, 16, 15, 16, 14, 16, 16, -1, -1, 16, 11, 16, 16, 16, 10, 16, 12, 16, 13, },

    };*/

    public static class State
    {
        public final static State INITIAL = new State(0);

        private int id;

        private State(@SuppressWarnings("hiding") int id)
        {
            this.id = id;
        }

        public int id()
        {
            return this.id;
        }
    }

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Lexer.class.getResourceAsStream("lexer.dat")));

            // read gotoTable
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][][];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                    length = s.readInt();
                    gotoTable[i][j] = new int[length][3];
                    for(int k = 0; k < gotoTable[i][j].length; k++)
                    {
                        for(int l = 0; l < 3; l++)
                        {
                            gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }

            // read accept
            length = s.readInt();
            accept = new int[length][];
            for(int i = 0; i < accept.length; i++)
            {
                length = s.readInt();
                accept[i] = new int[length];
                for(int j = 0; j < accept[i].length; j++)
                {
                    accept[i][j] = s.readInt();
                }
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }
}
