/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.graphviz.parser.lexer;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PushbackReader;
import org.anarres.graphviz.parser.lexer.LexerException;
import org.anarres.graphviz.parser.lexer.LexerInterface;
import org.anarres.graphviz.parser.node.EOF;
import org.anarres.graphviz.parser.node.TBlank;
import org.anarres.graphviz.parser.node.TComment;
import org.anarres.graphviz.parser.node.TKwDigraph;
import org.anarres.graphviz.parser.node.TKwEdge;
import org.anarres.graphviz.parser.node.TKwGraph;
import org.anarres.graphviz.parser.node.TKwNode;
import org.anarres.graphviz.parser.node.TKwStrict;
import org.anarres.graphviz.parser.node.TKwSubgraph;
import org.anarres.graphviz.parser.node.TLiteral;
import org.anarres.graphviz.parser.node.TStringLiteral;
import org.anarres.graphviz.parser.node.TTokArrow;
import org.anarres.graphviz.parser.node.TTokColon;
import org.anarres.graphviz.parser.node.TTokComma;
import org.anarres.graphviz.parser.node.TTokEq;
import org.anarres.graphviz.parser.node.TTokLbrace;
import org.anarres.graphviz.parser.node.TTokLink;
import org.anarres.graphviz.parser.node.TTokLsquare;
import org.anarres.graphviz.parser.node.TTokRbrace;
import org.anarres.graphviz.parser.node.TTokRsquare;
import org.anarres.graphviz.parser.node.TTokSemi;
import org.anarres.graphviz.parser.node.Token;

public class Lexer
implements LexerInterface {
    protected Token token;
    protected State state = State.INITIAL;
    private PushbackReader in;
    private int offset;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuilder text = new StringBuilder();
    private static int[][][][] gotoTable;
    private static int[][] accept;

    protected void filter() throws LexerException, IOException {
    }

    public Lexer(PushbackReader in) {
        this.in = in;
    }

    @Override
    public Token peek() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        return this.token;
    }

    @Override
    public Token next() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException {
        int dfa_state = 0;
        int start_offset = this.offset;
        int start_pos = this.pos;
        int start_line = this.line;
        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_offset = -1;
        int accept_pos = -1;
        int accept_line = -1;
        int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
        int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);
        while (true) {
            int c;
            if ((c = this.getChar()) != -1) {
                switch (c) {
                    case 10: {
                        if (this.cr) {
                            this.cr = false;
                            break;
                        }
                        ++this.offset;
                        ++this.line;
                        this.pos = 0;
                        break;
                    }
                    case 13: {
                        ++this.offset;
                        ++this.line;
                        this.pos = 0;
                        this.cr = true;
                        break;
                    }
                    default: {
                        ++this.offset;
                        ++this.pos;
                        this.cr = false;
                    }
                }
                this.text.append((char)c);
                block27: do {
                    int oldState = dfa_state < -1 ? -2 - dfa_state : dfa_state;
                    dfa_state = -1;
                    int[][] tmp1 = gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;
                    while (low <= high) {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];
                        if (c < tmp2[0]) {
                            high = middle - 1;
                            continue;
                        }
                        if (c > tmp2[1]) {
                            low = middle + 1;
                            continue;
                        }
                        dfa_state = tmp2[2];
                        continue block27;
                    }
                } while (dfa_state < -1);
            } else {
                dfa_state = -1;
            }
            if (dfa_state >= 0) {
                if (accept[dfa_state] == -1) continue;
                accept_state = dfa_state;
                accept_token = accept[dfa_state];
                accept_length = this.text.length();
                accept_offset = this.offset;
                accept_pos = this.pos;
                accept_line = this.line;
                continue;
            }
            if (accept_state == -1) break;
            switch (accept_token) {
                case 0: {
                    Token token = this.new0(start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 1: {
                    Token token = this.new1(start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 2: {
                    Token token = this.new2(start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 3: {
                    Token token = this.new3(start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 4: {
                    Token token = this.new4(start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 5: {
                    Token token = this.new5(start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 6: {
                    Token token = this.new6(start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 7: {
                    Token token = this.new7(start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 8: {
                    Token token = this.new8(start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 9: {
                    Token token = this.new9(start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 10: {
                    Token token = this.new10(start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 11: {
                    Token token = this.new11(start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 12: {
                    Token token = this.new12(start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 13: {
                    Token token = this.new13(start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 14: {
                    Token token = this.new14(start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 15: {
                    Token token = this.new15(start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 16: {
                    Token token = this.new16(this.getText(accept_length), start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 17: {
                    Token token = this.new17(this.getText(accept_length), start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 18: {
                    Token token = this.new18(this.getText(accept_length), start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 19: {
                    Token token = this.new19(this.getText(accept_length), start_offset, start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.offset = accept_offset;
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
            }
        }
        if (this.text.length() > 0) {
            throw new LexerException("[" + (start_line + 1) + "," + (start_pos + 1) + "] Unknown token: " + this.text);
        }
        EOF token = new EOF(start_offset, start_line + 1, start_pos + 1);
        return token;
    }

    Token new0(int offset, int line, int pos) {
        return new TTokLbrace(offset, line, pos);
    }

    Token new1(int offset, int line, int pos) {
        return new TTokRbrace(offset, line, pos);
    }

    Token new2(int offset, int line, int pos) {
        return new TTokLsquare(offset, line, pos);
    }

    Token new3(int offset, int line, int pos) {
        return new TTokRsquare(offset, line, pos);
    }

    Token new4(int offset, int line, int pos) {
        return new TTokArrow(offset, line, pos);
    }

    Token new5(int offset, int line, int pos) {
        return new TTokLink(offset, line, pos);
    }

    Token new6(int offset, int line, int pos) {
        return new TTokEq(offset, line, pos);
    }

    Token new7(int offset, int line, int pos) {
        return new TTokSemi(offset, line, pos);
    }

    Token new8(int offset, int line, int pos) {
        return new TTokComma(offset, line, pos);
    }

    Token new9(int offset, int line, int pos) {
        return new TTokColon(offset, line, pos);
    }

    Token new10(int offset, int line, int pos) {
        return new TKwStrict(offset, line, pos);
    }

    Token new11(int offset, int line, int pos) {
        return new TKwGraph(offset, line, pos);
    }

    Token new12(int offset, int line, int pos) {
        return new TKwDigraph(offset, line, pos);
    }

    Token new13(int offset, int line, int pos) {
        return new TKwSubgraph(offset, line, pos);
    }

    Token new14(int offset, int line, int pos) {
        return new TKwNode(offset, line, pos);
    }

    Token new15(int offset, int line, int pos) {
        return new TKwEdge(offset, line, pos);
    }

    Token new16(String text, int offset, int line, int pos) {
        return new TLiteral(text, offset, line, pos);
    }

    Token new17(String text, int offset, int line, int pos) {
        return new TStringLiteral(text, offset, line, pos);
    }

    Token new18(String text, int offset, int line, int pos) {
        return new TBlank(text, offset, line, pos);
    }

    Token new19(String text, int offset, int line, int pos) {
        return new TComment(text, offset, line, pos);
    }

    private int getChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        int result = this.in.read();
        if (result == -1) {
            this.eof = true;
        }
        return result;
    }

    private void pushBack(int acceptLength) throws IOException {
        int length = this.text.length();
        for (int i = length - 1; i >= acceptLength; --i) {
            this.eof = false;
            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(Token token) throws IOException {
        String text = token.getText();
        int length = text.length();
        for (int i = length - 1; i >= 0; --i) {
            this.eof = false;
            this.in.unread(text.charAt(i));
        }
        this.offset = token.getOffset();
        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    protected String getText(int acceptLength) {
        return this.text.substring(0, acceptLength);
    }

    static {
        try {
            int j;
            int i;
            DataInputStream s = new DataInputStream(new BufferedInputStream(Lexer.class.getResourceAsStream("lexer.dat")));
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for (i = 0; i < gotoTable.length; ++i) {
                length = s.readInt();
                Lexer.gotoTable[i] = new int[length][][];
                for (j = 0; j < gotoTable[i].length; ++j) {
                    length = s.readInt();
                    Lexer.gotoTable[i][j] = new int[length][3];
                    for (int k = 0; k < gotoTable[i][j].length; ++k) {
                        for (int l = 0; l < 3; ++l) {
                            Lexer.gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }
            length = s.readInt();
            accept = new int[length][];
            for (i = 0; i < accept.length; ++i) {
                length = s.readInt();
                Lexer.accept[i] = new int[length];
                for (j = 0; j < accept[i].length; ++j) {
                    Lexer.accept[i][j] = s.readInt();
                }
            }
            s.close();
        }
        catch (Exception e) {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }

    public static class State {
        public static final State INITIAL = new State(0);
        private int id;

        private State(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }
}

