/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.graphviz.builder.jgrapht;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.anarres.graphviz.builder.GraphVizEdge;
import org.anarres.graphviz.builder.GraphVizGraph;
import org.anarres.graphviz.builder.GraphVizNode;
import org.anarres.graphviz.builder.GraphVizScope;
import org.anarres.graphviz.builder.GraphVizable;
import org.jgrapht.Graph;

public class JGraphTGraphVizBuilder<V, E>
implements GraphVizScope,
GraphVizable {
    private static final Function<Object, String> EDGE_LABEL_NULL = Functions.constant(null);
    private final Graph<V, E> graph;
    private final GraphVizScope scope = this;
    private Function<? super V, String> nodeLabelFunction = Functions.toStringFunction();
    private Function<? super E, String> edgeLabelFunction = EDGE_LABEL_NULL;
    private Function<? super E, String> edgeHeadLabelFunction = EDGE_LABEL_NULL;
    private Function<? super E, String> edgeTailLabelFunction = EDGE_LABEL_NULL;

    public JGraphTGraphVizBuilder(@Nonnull Graph<V, E> graph, @CheckForNull Function<? super V, String> nodeLabelFunction) {
        this.graph = graph;
        this.nodeLabelFunction = (Function)MoreObjects.firstNonNull(nodeLabelFunction, (Object)Functions.toStringFunction());
    }

    public JGraphTGraphVizBuilder(@Nonnull Graph<V, E> graph) {
        this(graph, null);
    }

    @Nonnull
    public JGraphTGraphVizBuilder<V, E> withNodeLabelFunction(Function<? super V, String> nodeLabelFunction) {
        this.nodeLabelFunction = nodeLabelFunction;
        return this;
    }

    @Nonnull
    public JGraphTGraphVizBuilder<V, E> withEdgeLabelFunction(Function<? super E, String> edgeLabelFunction) {
        this.edgeLabelFunction = edgeLabelFunction;
        return this;
    }

    @Nonnull
    public JGraphTGraphVizBuilder<V, E> withEdgeHeadLabelFunction(Function<? super E, String> edgeHeadLabelFunction) {
        this.edgeHeadLabelFunction = edgeHeadLabelFunction;
        return this;
    }

    @Nonnull
    public JGraphTGraphVizBuilder<V, E> withEdgeTailLabelFunction(Function<? super E, String> edgeTailLabelFunction) {
        this.edgeTailLabelFunction = edgeTailLabelFunction;
        return this;
    }

    public void toGraphViz(@Nonnull GraphVizGraph out) {
        String label;
        for (Object node : this.graph.vertexSet()) {
            GraphVizNode n = out.node(this.scope, node);
            label = (String)this.nodeLabelFunction.apply(node);
            if (label == null) continue;
            n.label((CharSequence)label);
        }
        for (Object edge : this.graph.edgeSet()) {
            String tailLabel;
            String headLabel;
            GraphVizEdge e = out.edge(this.scope, this.graph.getEdgeSource(edge), this.graph.getEdgeTarget(edge));
            label = (String)this.edgeLabelFunction.apply(edge);
            if (label != null) {
                e.label((CharSequence)label);
            }
            if ((headLabel = (String)this.edgeHeadLabelFunction.apply(edge)) != null) {
                e.headLabel(headLabel);
            }
            if ((tailLabel = (String)this.edgeTailLabelFunction.apply(edge)) == null) continue;
            e.tailLabel(tailLabel);
        }
    }

    @Deprecated
    public void build(@Nonnull GraphVizGraph out) {
        this.toGraphViz(out);
    }
}

