/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.dhcp.server.pcap;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.anarres.dhcp.common.address.InterfaceAddress;
import org.apache.directory.server.dhcp.io.DhcpMessageDecoder;
import org.apache.directory.server.dhcp.io.DhcpMessageEncoder;
import org.apache.directory.server.dhcp.io.DhcpRequestContext;
import org.apache.directory.server.dhcp.messages.DhcpMessage;
import org.apache.directory.server.dhcp.service.DhcpService;
import org.pcap4j.core.PacketListener;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UdpPacket;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IpNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DhcpPacketListener
implements PacketListener {
    private static final Logger LOG = LoggerFactory.getLogger(DhcpPacketListener.class);
    private final DhcpMessageDecoder decoder = new DhcpMessageDecoder();
    private final DhcpMessageEncoder encoder = new DhcpMessageEncoder();
    private final DhcpService service;
    private final InterfaceAddress[] interfaceAddresses;

    public DhcpPacketListener(@Nonnull DhcpService service, @Nonnull InterfaceAddress[] interfaceAddresses) {
        this.service = service;
        this.interfaceAddresses = interfaceAddresses;
    }

    public void gotPacket(Packet rawPacket) {
        try {
            LOG.info("Read raw " + rawPacket);
            IpV4Packet ipPacket = (IpV4Packet)rawPacket.get(IpV4Packet.class);
            UdpPacket udpPacket = (UdpPacket)rawPacket.get(UdpPacket.class);
            byte[] dhcpData = udpPacket.getPayload().getRawData();
            InetSocketAddress remoteAddress = new InetSocketAddress(ipPacket.getHeader().getSrcAddr(), udpPacket.getHeader().getSrcPort().valueAsInt());
            InetSocketAddress localAddress = new InetSocketAddress(ipPacket.getHeader().getDstAddr(), udpPacket.getHeader().getDstPort().valueAsInt());
            DhcpRequestContext context = new DhcpRequestContext(this.interfaceAddresses, remoteAddress, localAddress);
            DhcpMessage request = this.decoder.decode(ByteBuffer.wrap(dhcpData));
            LOG.info("Read DHCP " + request);
            DhcpMessage reply = this.service.getReplyFor(context, request);
            if (reply == null) {
                return;
            }
            byte[] replyData = new byte[1536];
            ByteBuffer buffer = ByteBuffer.wrap(replyData);
            this.encoder.encode(buffer, reply);
            replyData = Arrays.copyOf(replyData, buffer.position());
            UnknownPacket.Builder dhcpBuilder = new UnknownPacket.Builder().rawData(replyData);
            UdpPacket.Builder udpBuilder = new UdpPacket.Builder().payloadBuilder((Packet.Builder)dhcpBuilder).srcPort(udpPacket.getHeader().getDstPort()).dstPort(udpPacket.getHeader().getSrcPort()).correctChecksumAtBuild(true).correctLengthAtBuild(true);
            IpV4Packet.Builder ipBuilder = new IpV4Packet.Builder().payloadBuilder((Packet.Builder)udpBuilder).srcAddr(null).dstAddr(null).protocol(IpNumber.UDP).correctChecksumAtBuild(true).correctLengthAtBuild(true).paddingAtBuild(true);
            EthernetPacket.Builder ethernetBuilder = new EthernetPacket.Builder().payloadBuilder((Packet.Builder)ipBuilder).type(EtherType.IPV4).paddingAtBuild(true);
            EthernetPacket ethernetPacket = ethernetBuilder.build();
        }
        catch (Exception e) {
            LOG.error("DHCP failed", (Throwable)e);
        }
    }
}

