/*
 * Decompiled with CFR 0.152.
 */
package org.anadix.swingparser;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Properties;
import org.anadix.html.Position;

public abstract class TagEvent
implements Serializable {
    private static final long serialVersionUID = -2820923796385117574L;
    private final BigInteger id;
    private final String tagName;
    private final Properties attributes;
    private final Position position;
    private final String source;

    public TagEvent(BigInteger id, String tagName, Properties attributes, Position position) {
        this(id, tagName, attributes, position, null);
    }

    public TagEvent(BigInteger id, String tagName, Properties attributes, Position position, String source) {
        if (id == null) {
            throw new NullPointerException("id can't be null");
        }
        if (tagName == null || tagName.length() == 0) {
            throw new NullPointerException("tagName can't be null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes can't be null");
        }
        this.id = id;
        this.tagName = tagName.toLowerCase();
        this.attributes = attributes;
        this.position = position;
        this.source = source;
    }

    public BigInteger getId() {
        return this.id;
    }

    public String getTagName() {
        return this.tagName;
    }

    public Properties getAttributes() {
        return this.attributes;
    }

    public Position getPosition() {
        return this.position;
    }

    public String getSource() {
        return this.source;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TagEvent other = (TagEvent)obj;
        return this.id.equals(other.getId());
    }

    public String toString() {
        return String.format("%s[ID='%s', tagName='%s', position='%s', properties='%s']", this.getClass().getName(), this.getId(), this.getTagName(), this.getPosition(), this.getAttributes());
    }
}

