/*
 * Decompiled with CFR 0.152.
 */
package org.anadix.swingparser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.text.html.parser.ParserDelegator;
import org.anadix.ElementFactory;
import org.anadix.Parser;
import org.anadix.Source;
import org.anadix.exceptions.ParserException;
import org.anadix.html.HTMLElementFactory;
import org.anadix.swingparser.StatefulParserCallback;
import org.anadix.utils.DroolsResource;
import org.apache.log4j.Logger;
import org.drools.builder.ResourceType;
import org.drools.decisiontable.ExternalSpreadsheetCompiler;
import org.drools.decisiontable.InputType;
import org.drools.io.ResourceFactory;

public class SwingParser
implements Parser {
    private static final Logger logger = Logger.getLogger(SwingParser.class);
    private final ParserDelegator parser = new ParserDelegator();

    public void parse(ElementFactory factory, Source source) throws ParserException {
        if (factory == null) {
            throw new NullPointerException("factory can't be null");
        }
        if (factory instanceof HTMLElementFactory) {
            factory.setAsGlobal("elementFactory");
            try {
                this.parser.parse(source.getReader(), new StatefulParserCallback((HTMLElementFactory)factory, source.getText()), true);
            }
            catch (IOException e) {
                logger.fatal((Object)"Exception during parsing", (Throwable)e);
                throw new ParserException("Unable to parse source", (Throwable)e);
            }
        } else {
            logger.fatal((Object)("Factory '" + factory.getClass().getName() + "' does not match '" + this.getElementFactoryClass().getName() + "'!"));
            throw new RuntimeException("Wrong factory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DroolsResource> getDroolsResources() {
        ArrayList<DroolsResource> result = new ArrayList<DroolsResource>();
        ExternalSpreadsheetCompiler compiler = new ExternalSpreadsheetCompiler();
        InputStream csvStream = null;
        InputStream templateStream = null;
        try {
            csvStream = SwingParser.class.getResourceAsStream("tags.csv");
            templateStream = SwingParser.class.getResourceAsStream("rule-template.drt");
            String generated = compiler.compile(csvStream, templateStream, InputType.CSV, 2, 1);
            logger.debug((Object)generated);
            result.add(new DroolsResource(ResourceFactory.newReaderResource((Reader)new StringReader(generated)), ResourceType.DRL));
        }
        finally {
            if (csvStream != null) {
                try {
                    csvStream.close();
                }
                catch (IOException ex) {
                    logger.fatal((Object)"could not close csvStream", (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            if (templateStream != null) {
                try {
                    templateStream.close();
                }
                catch (IOException ex) {
                    logger.fatal((Object)"could not close templateStream", (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
        }
        result.add(new DroolsResource(ResourceFactory.newInputStreamResource((InputStream)SwingParser.class.getResourceAsStream("swingparser.drl")), ResourceType.DRL));
        return result;
    }

    public Class<? extends ElementFactory> getElementFactoryClass() {
        return HTMLElementFactory.class;
    }
}

