/*
 * Decompiled with CFR 0.152.
 */
package org.anadix.swingparser;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.anadix.html.HTMLElementFactory;
import org.anadix.html.Position;
import org.anadix.swingparser.EndTagEvent;
import org.anadix.swingparser.SimpleTagEvent;
import org.anadix.swingparser.StartTagEvent;
import org.anadix.swingparser.TextContentEvent;
import org.apache.log4j.Logger;

public class StatefulParserCallback
extends HTMLEditorKit.ParserCallback {
    private static final Logger logger = Logger.getLogger(StatefulParserCallback.class);
    private static final BigInteger JUMP = BigInteger.valueOf(100L);
    private static final String ENTRY_POINT = "parser";
    private final HTMLElementFactory factory;
    private final String source;
    private final int[] lines;
    private BigInteger ID = BigInteger.ZERO;

    public StatefulParserCallback(HTMLElementFactory factory) {
        this(factory, null);
    }

    public StatefulParserCallback(HTMLElementFactory factory, String source) {
        this.factory = factory;
        this.source = source;
        factory.setGlobal("jump", (Object)JUMP);
        this.lines = StatefulParserCallback.countLines(this.source);
    }

    @Override
    public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        this.ID = this.ID.add(BigInteger.ONE);
        SimpleTagEvent e = new SimpleTagEvent(this.ID, t.toString(), this.parseAttributes(a), this.createPosition(pos), this.getSource(t.toString(), pos));
        if (e.getSource() != null && e.getSource().replace(" ", "").length() == e.getTagName().length() + 3) {
            logger.warn((Object)("end simple tag: " + e.getSource()));
        } else {
            this.factory.insertEvent(ENTRY_POINT, (Object)e);
        }
    }

    @Override
    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        this.ID = this.ID.add(BigInteger.ONE);
        StartTagEvent e = new StartTagEvent(this.ID, t.toString(), this.parseAttributes(a), this.createPosition(pos), this.getSource(t.toString(), pos));
        if (e.getSource() != null && e.getSource().replace(" ", "").length() == e.getTagName().length() + 3) {
            logger.warn((Object)("end simple tag: " + e.getSource()));
        } else {
            this.factory.insertEvent(ENTRY_POINT, (Object)e);
        }
        this.ID = this.ID.multiply(JUMP);
    }

    @Override
    public void handleEndTag(HTML.Tag t, int pos) {
        this.ID = this.ID.divide(JUMP);
        EndTagEvent e = new EndTagEvent(this.ID, t.toString().toLowerCase(), this.createPosition(pos));
        this.factory.insertEvent(ENTRY_POINT, (Object)e);
    }

    @Override
    public void handleText(char[] data, int pos) {
        TextContentEvent e = new TextContentEvent(this.ID.divide(JUMP), new String(data), pos);
        this.factory.insertEvent(ENTRY_POINT, (Object)e);
    }

    @Override
    public void handleError(String errorMsg, int pos) {
        logger.error((Object)errorMsg);
    }

    private static int[] countLines(String source) {
        if (source == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        int pos = 0;
        while ((pos = source.indexOf(10, pos)) != -1) {
            list.add(pos);
            ++pos;
        }
        int[] result = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (Integer)list.get(i);
        }
        return result;
    }

    private Properties parseAttributes(MutableAttributeSet attributes) {
        Properties result = new Properties();
        Enumeration<?> names = attributes.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            result.setProperty(name.toString().toLowerCase(), attributes.getAttribute(name).toString().toLowerCase());
        }
        return result;
    }

    private String getSource(String tagName, int position) {
        if (this.source == null) {
            return null;
        }
        int beginIndex = this.source.substring(0, position + tagName.length()).lastIndexOf("<");
        int endIndex = this.source.indexOf(">", beginIndex);
        if (beginIndex > -1 && endIndex > -1) {
            String result = this.source.substring(beginIndex, endIndex + 1);
            result = result.replace("\r", "\n");
            result = result.replace("\n", " ");
            result = result.replace("\t", " ");
            while (result.contains("  ")) {
                result = result.replace("  ", " ");
            }
            return result;
        }
        logger.error((Object)String.format("Could not find tag %s starting at %s", tagName, position));
        return "!" + tagName + "(" + beginIndex + "," + endIndex + ") - " + this.source.substring(position, position + 50);
    }

    private Position createPosition(int position) {
        if (this.lines == null || this.lines.length < 1) {
            return new Position(position);
        }
        int line = 0;
        int col = 0;
        int i = 0;
        while (position > this.lines[i++]) {
        }
        line = i;
        col = position - (i > 1 ? this.lines[i - 2] : 0);
        return new Position(line, col);
    }
}

