/*
 * Decompiled with CFR 0.152.
 */
package org.amqphub.quarkus.qpid.jms.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import javax.jms.Destination;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.Queue;
import javax.ws.rs.core.Response;
import org.amqphub.quarkus.qpid.jms.it.QpidJmsTestSupport;
import org.amqphub.quarkus.qpid.jms.it.artemis.BrokerTestResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=BrokerTestResource.class)
public class QpidJmsSendTest {
    @Test
    public void testSend() throws Exception {
        String body = QpidJmsTestSupport.generateBody();
        Response response = (Response)RestAssured.with().body(body).post("/testqpidjms", new Object[0]);
        Assertions.assertEquals((int)Response.Status.NO_CONTENT.getStatusCode(), (int)response.statusCode());
        try (JMSContext context = QpidJmsTestSupport.createContext();){
            Queue destination = context.createQueue("test-qpid-jms-send");
            JMSConsumer consumer = context.createConsumer((Destination)destination);
            Assertions.assertEquals((Object)body, (Object)consumer.receiveBody(String.class, 2000L), (String)"Received body did not match that sent");
        }
    }
}

