/*
 * Decompiled with CFR 0.152.
 */
package org.amqphub.quarkus.qpid.jms.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSProducer;
import javax.jms.Queue;
import javax.ws.rs.core.Response;
import org.amqphub.quarkus.qpid.jms.it.QpidJmsTestSupport;
import org.amqphub.quarkus.qpid.jms.it.artemis.BrokerTestResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=BrokerTestResource.class)
public class QpidJmsReceiveTest {
    @Test
    public void testReceive() throws Exception {
        String body = QpidJmsTestSupport.generateBody();
        try (JMSContext context = QpidJmsTestSupport.createContext();){
            Queue destination = context.createQueue("test-qpid-jms-receive");
            JMSProducer producer = context.createProducer();
            producer.send((Destination)destination, body);
        }
        Response response = (Response)RestAssured.with().body(body).get("/testqpidjms", new Object[0]);
        Assertions.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.statusCode());
        Assertions.assertEquals((Object)body, (Object)response.getBody().asString(), (String)"Received body did not match that sent");
    }
}

