/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aludratest.cloud.resource.user.MutableResourceTypeAuthorizationConfig;
import org.aludratest.cloud.resource.user.ResourceTypeAuthorization;
import org.aludratest.cloud.resource.user.ResourceTypeAuthorizationConfig;
import org.aludratest.cloud.user.User;

public class SimpleResourceTypeAuthorizationConfig
implements MutableResourceTypeAuthorizationConfig {
    private Map<User, ResourceTypeAuthorization> userAuthorizations = new HashMap<User, ResourceTypeAuthorization>();

    public SimpleResourceTypeAuthorizationConfig() {
    }

    public SimpleResourceTypeAuthorizationConfig(ResourceTypeAuthorizationConfig original) {
        for (User u : original.getConfiguredUsers()) {
            this.userAuthorizations.put(u, original.getResourceTypeAuthorizationForUser(u));
        }
    }

    public ResourceTypeAuthorization getResourceTypeAuthorizationForUser(User user) {
        return this.userAuthorizations.get(user);
    }

    public List<User> getConfiguredUsers() {
        return new ArrayList<User>(this.userAuthorizations.keySet());
    }

    public void addUser(User user, ResourceTypeAuthorization authorization) throws IllegalArgumentException {
        if (this.userAuthorizations.containsKey(user)) {
            throw new IllegalArgumentException("Authorization for user " + user + " already set");
        }
        this.userAuthorizations.put(user, authorization);
    }

    public void removeUser(User user) throws IllegalArgumentException {
        if (!this.userAuthorizations.containsKey(user)) {
            throw new IllegalArgumentException("No authorization for user " + user + " found.");
        }
        this.userAuthorizations.remove(user);
    }

    public void editUserAuthorization(User user, ResourceTypeAuthorization newAuthorization) throws IllegalArgumentException {
        this.removeUser(user);
        this.addUser(user, newAuthorization);
    }
}

