/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.user;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.aludratest.cloud.impl.user.LocalUserImpl;
import org.aludratest.cloud.user.StoreException;
import org.aludratest.cloud.user.User;
import org.aludratest.cloud.user.UserDatabase;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.databene.commons.Filter;
import org.json.JSONException;
import org.json.JSONObject;

@Component(role=UserDatabase.class, hint="local-file")
public class LocalUserDatabaseImpl
implements UserDatabase {
    public static final String HINT = "local-file";
    private static final String DB_FILE = ".atcloudmanager/users.json";

    public String getSource() {
        return HINT;
    }

    public Iterator<User> getAllUsers(Filter<User> userFilter) throws StoreException {
        JSONObject contents = this.load();
        try {
            ArrayList<LocalUserImpl> result = new ArrayList<LocalUserImpl>();
            JSONObject users = contents.getJSONObject("users");
            Iterator iter = users.keys();
            while (iter.hasNext()) {
                String userName = iter.next().toString();
                JSONObject o = users.getJSONObject(userName);
                LocalUserImpl user = new LocalUserImpl(userName, LocalUserDatabaseImpl.toMap(o.getJSONObject("attributes")));
                if (userFilter != null && !userFilter.accept((Object)user)) continue;
                result.add(user);
            }
            return result.iterator();
        }
        catch (JSONException e) {
            throw new StoreException("Unexpected format expection", (Throwable)e);
        }
    }

    public User authenticate(String userName, String password) throws StoreException {
        JSONObject contents = this.load();
        try {
            JSONObject users = contents.getJSONObject("users");
            if (!users.has(userName)) {
                return null;
            }
            JSONObject userObject = users.getJSONObject(userName);
            String hash = LocalUserDatabaseImpl.calculateHash(userName, password);
            if (userObject.getString("passwordHash").equals(hash)) {
                return new LocalUserImpl(userName, LocalUserDatabaseImpl.toMap(userObject.getJSONObject("attributes")));
            }
        }
        catch (JSONException e) {
            throw new StoreException("Unexpected format expection", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new StoreException("SHA-1 algorithm is unsupported on this machine");
        }
        return null;
    }

    public User findUser(String userName) throws StoreException {
        JSONObject contents = this.load();
        try {
            JSONObject users = contents.getJSONObject("users");
            if (!users.has(userName)) {
                return null;
            }
            JSONObject o = users.getJSONObject(userName);
            return new LocalUserImpl(userName, LocalUserDatabaseImpl.toMap(o.getJSONObject("attributes")));
        }
        catch (JSONException e) {
            throw new StoreException("Unexpected format expection", (Throwable)e);
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public void delete(User user) throws StoreException {
        if (!user.getSource().equals(this.getSource())) {
            throw new StoreException("Unsupported user object: Source is " + user.getSource() + " instead of " + this.getSource());
        }
        JSONObject contents = this.load();
        try {
            JSONObject users = contents.getJSONObject("users");
            if (users.has(user.getName())) {
                users.remove(user.getName());
                this.save(contents);
            }
        }
        catch (JSONException e) {
            throw new StoreException("Unexpected format expection", (Throwable)e);
        }
    }

    public User create(String userName) throws IllegalArgumentException, StoreException {
        JSONObject contents = this.load();
        try {
            JSONObject users = contents.getJSONObject("users");
            if (users.has(userName)) {
                throw new IllegalArgumentException("User " + userName + " does already exist");
            }
            JSONObject newUserObject = new JSONObject();
            newUserObject.put("passwordHash", (Object)LocalUserDatabaseImpl.calculateHash(userName, "password"));
            newUserObject.put("attributes", (Object)new JSONObject());
            users.put(userName, (Object)newUserObject);
            this.save(contents);
            return new LocalUserImpl(userName, new HashMap<String, String>());
        }
        catch (JSONException e) {
            throw new StoreException("Unexpected format expection", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new StoreException("SHA-1 algorithm is unsupported on this machine");
        }
    }

    public void changePassword(User user, String newPassword) throws StoreException {
        if (!user.getSource().equals(this.getSource())) {
            throw new StoreException("Unsupported user object: Source is " + user.getSource() + " instead of " + this.getSource());
        }
        JSONObject contents = this.load();
        try {
            JSONObject users = contents.getJSONObject("users");
            if (!users.has(user.getName())) {
                throw new IllegalArgumentException("User " + user.getName() + " does not exist");
            }
            JSONObject userObject = users.getJSONObject(user.getName());
            userObject.put("passwordHash", (Object)LocalUserDatabaseImpl.calculateHash(user.getName(), newPassword));
            this.save(contents);
        }
        catch (JSONException e) {
            throw new StoreException("Unexpected format expection", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new StoreException("SHA-1 algorithm is unsupported on this machine");
        }
    }

    public void modifyUserAttribute(User user, String attributeKey, String newAttributeValue) throws StoreException {
        if (!user.getSource().equals(this.getSource())) {
            throw new StoreException("Unsupported user object: Source is " + user.getSource() + " instead of " + this.getSource());
        }
        LocalUserImpl localUser = (LocalUserImpl)user;
        JSONObject contents = this.load();
        try {
            JSONObject users = contents.getJSONObject("users");
            if (!users.has(user.getName())) {
                throw new IllegalArgumentException("User " + user.getName() + " does not exist");
            }
            JSONObject userObject = users.getJSONObject(user.getName());
            Map<String, String> attributes = LocalUserDatabaseImpl.toMap(userObject.getJSONObject("attributes"));
            if (newAttributeValue == null) {
                attributes.remove(attributeKey);
            } else {
                attributes.put(attributeKey, newAttributeValue);
            }
            localUser.setAttributes(attributes);
            userObject.put("attributes", (Object)new JSONObject(attributes));
            this.save(contents);
        }
        catch (JSONException e) {
            throw new StoreException("Unexpected format expection", (Throwable)e);
        }
    }

    public boolean supportsUserAttribute(String attributeKey) {
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JSONObject load() throws StoreException {
        JSONObject e2222222;
        File home = new File(System.getProperty("user.home"));
        File dbFile = new File(home, DB_FILE);
        if (!dbFile.isFile()) {
            JSONObject empty = new JSONObject();
            try {
                empty.put("users", (Object)new JSONObject());
                return empty;
            }
            catch (JSONException e2222222) {
                throw new RuntimeException(e2222222);
            }
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(dbFile);
            e2222222 = new JSONObject(IOUtils.toString((InputStream)fis, (String)"UTF-8"));
        }
        catch (IOException e3) {
            try {
                throw new StoreException("Could not load local user database", (Throwable)e3);
                catch (JSONException e4) {
                    throw new StoreException("Local user database " + dbFile.getAbsolutePath() + " is corrupt.");
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return e2222222;
    }

    protected void save(JSONObject contents) throws StoreException {
        File home = new File(System.getProperty("user.home"));
        File dbFile = new File(home, DB_FILE);
        FileOutputStream fos = null;
        try {
            dbFile.getParentFile().mkdirs();
            fos = new FileOutputStream(dbFile);
            fos.write(contents.toString().getBytes("UTF-8"));
        }
        catch (IOException e) {
            try {
                throw new StoreException("Could not write local user database", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    private static Map<String, String> toMap(JSONObject obj) throws JSONException {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator keys = obj.keys();
        while (keys.hasNext()) {
            Object o = keys.next();
            Object val = obj.get(o.toString());
            if (!(val instanceof String)) continue;
            result.put(o.toString(), val.toString());
        }
        return result;
    }

    private static String calculateHash(String userName, String password) throws NoSuchAlgorithmException {
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update((userName + "/" + password).getBytes("UTF-8"));
            byte[] data = crypt.digest();
            return new String(Base64.encodeBase64((byte[])data), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

