/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.user;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aludratest.cloud.app.CloudManagerApp;
import org.aludratest.cloud.user.StoreException;
import org.aludratest.cloud.user.User;
import org.aludratest.cloud.user.UserDatabase;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicAuthUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthUtil.class);

    private BasicAuthUtil() {
    }

    public static User authenticate(String authHeader) throws StoreException, IllegalArgumentException {
        User user;
        String userPass;
        Pattern pAuth = Pattern.compile("Basic (.+)");
        Matcher m = pAuth.matcher(authHeader);
        if (!m.matches()) {
            throw new IllegalArgumentException();
        }
        try {
            userPass = new String(Base64.decodeBase64((String)m.group(1)), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("No UTF-8 supported on this machine");
        }
        if (!userPass.contains(":")) {
            throw new IllegalArgumentException();
        }
        String[] up = userPass.split(":");
        if (up[0].length() == 0 || up[1].length() == 0) {
            throw new IllegalArgumentException();
        }
        UserDatabase userDatabase = CloudManagerApp.getInstance().getSelectedUserDatabase();
        if (userDatabase == null || (user = userDatabase.authenticate(up[0], up[1])) == null) {
            throw new IllegalArgumentException();
        }
        return user;
    }

    public static User authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String authHeader = request.getHeader("Authorization");
            if (authHeader == null) {
                response.setHeader("WWW-Authenticate", "Basic realm=\"AludraTest Cloud Manager\"");
                response.sendError(401);
                return null;
            }
            User user = BasicAuthUtil.authenticate(authHeader);
            if (user == null) {
                response.sendError(403);
            }
            return user;
        }
        catch (StoreException e) {
            LOG.error("Could not check user authentication", (Throwable)e);
            response.sendError(403);
            return null;
        }
        catch (IllegalArgumentException e) {
            response.sendError(403);
            return null;
        }
    }
}

