/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.rest;

import java.util.Iterator;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.aludratest.cloud.app.CloudManagerApp;
import org.aludratest.cloud.config.ConfigException;
import org.aludratest.cloud.rest.AbstractRestConnector;
import org.aludratest.cloud.rest.RestConnector;
import org.aludratest.cloud.user.StoreException;
import org.aludratest.cloud.user.User;
import org.aludratest.cloud.user.UserDatabase;
import org.codehaus.plexus.component.annotations.Component;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Component(role=RestConnector.class, hint="users")
@Path(value="/users")
public class UserEndpoint
extends AbstractRestConnector {
    @GET
    @Produces(value={"application/json"})
    public Response getUsers() throws JSONException {
        JSONObject result = new JSONObject();
        UserDatabase users = CloudManagerApp.getInstance().getSelectedUserDatabase();
        if (users == null) {
            return this.wrapResultObject(result);
        }
        result.put("isEditable", !users.isReadOnly());
        JSONArray arr = new JSONArray();
        try {
            Iterator iter = users.getAllUsers(null);
            while (iter.hasNext()) {
                User user = (User)iter.next();
                JSONObject u = new JSONObject();
                u.put("name", (Object)user.getName());
                u.put("source", (Object)user.getSource());
                String[] attrs = user.getDefinedUserAttributes();
                if (attrs.length > 0) {
                    JSONObject a = new JSONObject();
                    for (String attr : attrs) {
                        a.put(attr, (Object)user.getUserAttribute(attr));
                    }
                    u.put("customAttributes", (Object)a);
                }
                arr.put((Object)u);
            }
            result.put("users", (Object)arr);
            return this.wrapResultObject(result);
        }
        catch (StoreException e) {
            this.getLogger().error("Could not retrieve users list", (Throwable)e);
            return this.createErrorObject(new RuntimeException("Could not retrieve users list."), 500);
        }
    }

    @GET
    @Path(value="/{userName}")
    @Produces(value={"application/json"})
    public Response getUser(@PathParam(value="userName") String userName) throws JSONException {
        JSONObject result = new JSONObject();
        UserDatabase users = CloudManagerApp.getInstance().getSelectedUserDatabase();
        if (users == null) {
            return this.wrapResultObject(result);
        }
        if (userName == null || "".equals(userName)) {
            return Response.status((int)400).build();
        }
        try {
            User user = users.findUser(userName);
            if (user == null) {
                return Response.status((int)404).build();
            }
            result.put("user", (Object)this.getUserJSON(user));
            return this.wrapResultObject(result);
        }
        catch (StoreException e) {
            this.getLogger().error("Could not retrieve user", (Throwable)e);
            return this.createErrorObject(new RuntimeException("Could not retrieve user information."), 500);
        }
    }

    @PUT
    @Path(value="/{userName}")
    @Produces(value={"application/json"})
    public Response addUser(@PathParam(value="userName") String userName) throws JSONException {
        JSONObject result = new JSONObject();
        UserDatabase users = CloudManagerApp.getInstance().getSelectedUserDatabase();
        if (users == null) {
            return this.wrapResultObject(result);
        }
        if (users.isReadOnly()) {
            return this.createErrorObject(new ConfigException("The current user database is read only."));
        }
        if (userName == null || "".equals(userName)) {
            return Response.status((int)400).build();
        }
        try {
            User user = users.findUser(userName);
            if (user != null) {
                return this.createErrorObject(new ConfigException("A user with this name already exists."));
            }
            user = users.create(userName);
            result.put("user", (Object)this.getUserJSON(user));
            return this.wrapResultObject(result, 201);
        }
        catch (StoreException e) {
            this.getLogger().error("Could not query user database", (Throwable)e);
            return this.createErrorObject(new RuntimeException("Could not query user database"), 500);
        }
    }

    @DELETE
    @Path(value="/{userName}")
    @Produces(value={"application/json"})
    public Response deleteUser(@PathParam(value="userName") String userName) {
        JSONObject result = new JSONObject();
        UserDatabase users = CloudManagerApp.getInstance().getSelectedUserDatabase();
        if (users == null) {
            return this.wrapResultObject(result);
        }
        if (users.isReadOnly()) {
            return this.createErrorObject(new ConfigException("The current user database is read only."));
        }
        if (userName == null || "".equals(userName)) {
            return Response.status((int)400).build();
        }
        try {
            User user = users.findUser(userName);
            if (user == null) {
                return Response.status((int)404).build();
            }
            users.delete(user);
            return Response.ok().build();
        }
        catch (StoreException e) {
            this.getLogger().error("Could not query user database", (Throwable)e);
            return this.createErrorObject(new RuntimeException("Could not query user database"), 500);
        }
    }

    private JSONObject getUserJSON(User user) throws JSONException {
        JSONObject u = new JSONObject();
        u.put("name", (Object)user.getName());
        u.put("source", (Object)user.getSource());
        String[] attrs = user.getDefinedUserAttributes();
        if (attrs.length > 0) {
            JSONObject a = new JSONObject();
            for (String attr : attrs) {
                a.put(attr, (Object)user.getUserAttribute(attr));
            }
            u.put("customAttributes", (Object)a);
        }
        return u;
    }
}

