/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.rest;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.aludratest.cloud.app.CloudManagerApp;
import org.aludratest.cloud.config.ConfigException;
import org.aludratest.cloud.config.Configurable;
import org.aludratest.cloud.manager.ManagedResourceQuery;
import org.aludratest.cloud.manager.ResourceManager;
import org.aludratest.cloud.module.ResourceModule;
import org.aludratest.cloud.request.ResourceRequest;
import org.aludratest.cloud.resource.Resource;
import org.aludratest.cloud.resource.ResourceStateHolder;
import org.aludratest.cloud.resourcegroup.AuthorizingResourceGroup;
import org.aludratest.cloud.resourcegroup.AuthorizingResourceGroupAdmin;
import org.aludratest.cloud.resourcegroup.ResourceGroup;
import org.aludratest.cloud.resourcegroup.ResourceGroupManager;
import org.aludratest.cloud.resourcegroup.ResourceGroupManagerAdmin;
import org.aludratest.cloud.rest.AbstractRestConnector;
import org.aludratest.cloud.rest.RestConnector;
import org.aludratest.cloud.user.StoreException;
import org.aludratest.cloud.user.User;
import org.codehaus.plexus.component.annotations.Component;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=RestConnector.class, hint="groups")
@Path(value="/groups")
public class GroupEndpoint
extends AbstractRestConnector {
    private static final Logger LOG = LoggerFactory.getLogger(GroupEndpoint.class);
    private static final DateTimeFormatter ISO_FORMATTER = new DateTimeFormatterBuilder().appendPattern("YYYY-MM-dd'T'HH:mm:ssZZ").toFormatter();

    @GET
    @Produces(value={"application/json"})
    public Response getAllGroups() throws JSONException {
        JSONObject result = new JSONObject();
        JSONArray arr = new JSONArray();
        ResourceGroupManager manager = CloudManagerApp.getInstance().getResourceGroupManager();
        for (int groupId : manager.getAllResourceGroupIds()) {
            ResourceGroup group = manager.getResourceGroup(groupId);
            JSONObject obj = new JSONObject();
            obj.put("id", groupId);
            obj.put("name", (Object)manager.getResourceGroupName(groupId));
            obj.put("type", (Object)group.getResourceType().getName());
            obj.put("resourceCount", group.getResourceCollection().getResourceCount());
            arr.put((Object)obj);
        }
        result.put("groups", (Object)arr);
        return this.wrapResultObject(result);
    }

    @GET
    @Path(value="/{groupId: [0-9]{1,10}}")
    @Produces(value={"application/json"})
    public Response getGroup(@PathParam(value="groupId") int groupId) throws JSONException {
        return this.getGroup(groupId, 200);
    }

    private Response getGroup(int groupId, int returnCode) throws JSONException {
        ResourceGroupManager manager = CloudManagerApp.getInstance().getResourceGroupManager();
        ResourceGroup group = manager.getResourceGroup(groupId);
        if (group == null) {
            return Response.status((int)404).build();
        }
        JSONObject result = new JSONObject();
        result.put("id", groupId);
        result.put("name", (Object)manager.getResourceGroupName(groupId));
        result.put("type", (Object)group.getResourceType().getName());
        result.put("resourceCount", group.getResourceCollection().getResourceCount());
        return this.wrapResultObject(result, returnCode);
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response createGroup(@FormParam(value="name") String name, @FormParam(value="type") String type) throws JSONException {
        ResourceModule module = null;
        for (ResourceModule m : CloudManagerApp.getInstance().getAllResourceModules()) {
            if (!m.getResourceType().getName().equals(type)) continue;
            module = m;
        }
        if (module == null) {
            return this.createErrorObject(new IllegalArgumentException("Unknown resource type: " + type));
        }
        ResourceGroupManager manager = CloudManagerApp.getInstance().getResourceGroupManager();
        ResourceGroupManagerAdmin admin = (ResourceGroupManagerAdmin)((Configurable)manager).getAdminInterface(ResourceGroupManagerAdmin.class);
        try {
            int groupId = admin.createResourceGroup(module.getResourceType(), name);
            admin.commit();
            return this.getGroup(groupId, 201);
        }
        catch (ConfigException e) {
            return this.createErrorObject(e);
        }
    }

    @POST
    @Path(value="/{groupId: [0-9]{1,10}}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response renameGroup(@PathParam(value="groupId") int groupId, @FormParam(value="name") String name) throws JSONException {
        ResourceGroupManager manager = CloudManagerApp.getInstance().getResourceGroupManager();
        ResourceGroupManagerAdmin admin = (ResourceGroupManagerAdmin)((Configurable)manager).getAdminInterface(ResourceGroupManagerAdmin.class);
        ResourceGroup group = manager.getResourceGroup(groupId);
        if (group == null) {
            return Response.status((int)404).build();
        }
        try {
            admin.renameResourceGroup(groupId, name);
            admin.commit();
            return this.getGroup(groupId, 200);
        }
        catch (ConfigException e) {
            return this.createErrorObject(e);
        }
    }

    @DELETE
    @Path(value="/{groupId: [0-9]{1,10}}")
    @Produces(value={"application/json"})
    public Response deleteGroup(@PathParam(value="groupId") int groupId) {
        ResourceGroupManager manager = CloudManagerApp.getInstance().getResourceGroupManager();
        ResourceGroupManagerAdmin admin = (ResourceGroupManagerAdmin)((Configurable)manager).getAdminInterface(ResourceGroupManagerAdmin.class);
        ResourceGroup group = manager.getResourceGroup(groupId);
        if (group == null) {
            return Response.status((int)404).build();
        }
        try {
            admin.deleteResourceGroup(groupId);
            admin.commit();
            return Response.ok().build();
        }
        catch (ConfigException e) {
            return this.createErrorObject(e);
        }
    }

    @GET
    @Path(value="/{groupId: [0-9]{1,10}}/resources")
    @Produces(value={"application/json"})
    public Response getResources(@PathParam(value="groupId") int groupId) throws JSONException {
        ResourceGroupManager groupManager = CloudManagerApp.getInstance().getResourceGroupManager();
        ResourceGroup group = groupManager.getResourceGroup(groupId);
        if (group == null) {
            return Response.status((int)404).build();
        }
        ResourceManager manager = CloudManagerApp.getInstance().getResourceManager();
        List queries = manager.getAllRunningQueries();
        JSONArray resources = new JSONArray();
        for (ResourceStateHolder rsh : group.getResourceCollection()) {
            Resource res = (Resource)rsh;
            ManagedResourceQuery query = null;
            for (ManagedResourceQuery q : queries) {
                if (!rsh.equals(q.getReceivedResource())) continue;
                query = q;
                break;
            }
            JSONObject obj = new JSONObject();
            obj.put("type", (Object)res.getResourceType().getName());
            obj.put("state", (Object)res.getState().toString());
            obj.put("resourceText", (Object)res.toString());
            if (query != null) {
                JSONObject queryObj = new JSONObject();
                ResourceRequest request = query.getRequest();
                queryObj.put("user", (Object)request.getRequestingUser().getName());
                if (request.getJobName() != null) {
                    queryObj.put("jobName", (Object)request.getJobName());
                }
                if (request.getCustomAttributes() != null && !request.getCustomAttributes().isEmpty()) {
                    JSONObject attrs = new JSONObject();
                    for (Map.Entry attr : request.getCustomAttributes().entrySet()) {
                        if (attr.getValue() == null) continue;
                        attrs.put((String)attr.getKey(), (Object)attr.getValue().toString());
                    }
                    queryObj.put("customAttributes", (Object)attrs);
                }
                queryObj.put("enqueueStartTime", (Object)query.getEnqueueStartTime().toString(ISO_FORMATTER));
                queryObj.put("resourceReceivedTime", (Object)query.getResourceReceivedTime().toString(ISO_FORMATTER));
                obj.put("query", (Object)queryObj);
            }
            resources.put((Object)obj);
        }
        JSONObject result = new JSONObject();
        result.put("resources", (Object)resources);
        return this.wrapResultObject(result);
    }

    @GET
    @Path(value="/{groupId: [0-9]{1,10}}/users")
    @Produces(value={"application/json"})
    public Response getUsers(@PathParam(value="groupId") int groupId) throws JSONException {
        return this.getUsers(groupId, 200);
    }

    private Response getUsers(int groupId, int returnCode) throws JSONException {
        List users;
        ResourceGroupManager manager = CloudManagerApp.getInstance().getResourceGroupManager();
        ResourceGroup group = manager.getResourceGroup(groupId);
        if (group == null || !(group instanceof Configurable) || !(group instanceof AuthorizingResourceGroup)) {
            return Response.status((int)404).build();
        }
        AuthorizingResourceGroupAdmin admin = (AuthorizingResourceGroupAdmin)((Configurable)group).getAdminInterface(AuthorizingResourceGroupAdmin.class);
        if (admin == null) {
            return Response.status((int)404).build();
        }
        if (!((AuthorizingResourceGroup)group).isLimitingUsers()) {
            users = Collections.emptyList();
        } else {
            try {
                users = admin.getConfiguredAuthorizedUsers();
            }
            catch (StoreException e) {
                LOG.error("Exception when querying user database", (Throwable)e);
                return Response.status((int)500).build();
            }
        }
        JSONObject result = new JSONObject();
        JSONArray array = new JSONArray();
        for (User user : users) {
            JSONObject o = new JSONObject();
            o.put("source", (Object)user.getSource());
            o.put("name", (Object)user.getName());
            array.put((Object)o);
        }
        result.put("users", (Object)array);
        return this.wrapResultObject(result, returnCode);
    }

    @PUT
    @Path(value="/{groupId: [0-9]{1,10}}/users/{user}")
    @Produces(value={"application/json"})
    public Response addUser(@PathParam(value="groupId") int groupId, @PathParam(value="user") String user) throws JSONException {
        return this.doUserAction(groupId, user, false);
    }

    @DELETE
    @Path(value="/{groupId: [0-9]{1,10}}/users/{user}")
    @Produces(value={"application/json"})
    public Response removeUser(@PathParam(value="groupId") int groupId, @PathParam(value="user") String user) throws JSONException {
        return this.doUserAction(groupId, user, true);
    }

    @DELETE
    @Path(value="/{groupId: [0-9]{1,10}}/users")
    @Produces(value={"application/json"})
    public Response disableUserLimit(@PathParam(value="groupId") int groupId) {
        ResourceGroupManager manager = CloudManagerApp.getInstance().getResourceGroupManager();
        ResourceGroup group = manager.getResourceGroup(groupId);
        if (group == null || !(group instanceof Configurable) || !(group instanceof AuthorizingResourceGroup)) {
            return Response.status((int)404).build();
        }
        AuthorizingResourceGroupAdmin admin = (AuthorizingResourceGroupAdmin)((Configurable)group).getAdminInterface(AuthorizingResourceGroupAdmin.class);
        if (admin == null) {
            return Response.status((int)404).build();
        }
        try {
            admin.setLimitingUsers(false);
            admin.commit();
            return Response.ok().build();
        }
        catch (ConfigException e) {
            return this.createErrorObject(e);
        }
    }

    private Response doUserAction(int groupId, String user, boolean delete) throws JSONException {
        User userObject;
        ResourceGroupManager manager = CloudManagerApp.getInstance().getResourceGroupManager();
        ResourceGroup group = manager.getResourceGroup(groupId);
        if (group == null || !(group instanceof Configurable) || !(group instanceof AuthorizingResourceGroup)) {
            return Response.status((int)404).build();
        }
        try {
            userObject = CloudManagerApp.getInstance().getSelectedUserDatabase().findUser(user);
        }
        catch (StoreException e) {
            LOG.error("Exception when querying user database", (Throwable)e);
            return Response.status((int)500).build();
        }
        if (userObject == null) {
            return this.createErrorObject(new IllegalArgumentException("User " + user + " not found in current user database."));
        }
        AuthorizingResourceGroupAdmin admin = (AuthorizingResourceGroupAdmin)((Configurable)group).getAdminInterface(AuthorizingResourceGroupAdmin.class);
        if (admin == null) {
            return Response.status((int)404).build();
        }
        if (delete) {
            admin.removeAuthorizedUser(userObject);
        } else {
            admin.setLimitingUsers(true);
            admin.addAuthorizedUser(userObject);
        }
        try {
            admin.commit();
            if (delete) {
                return Response.ok().build();
            }
            return this.getUsers(groupId, 201);
        }
        catch (ConfigException e) {
            return this.createErrorObject(e);
        }
    }
}

