/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.aludratest.cloud.app.CloudManagerApp;
import org.aludratest.cloud.config.ConfigException;
import org.aludratest.cloud.config.ConfigUtil;
import org.aludratest.cloud.config.MainPreferences;
import org.aludratest.cloud.config.MutablePreferences;
import org.aludratest.cloud.config.Preferences;
import org.aludratest.cloud.config.SimplePreferences;
import org.aludratest.cloud.impl.app.CloudManagerApplicationHolder;
import org.aludratest.cloud.rest.AbstractRestConnector;
import org.aludratest.cloud.rest.RestConnector;
import org.codehaus.plexus.component.annotations.Component;
import org.json.JSONException;
import org.json.JSONObject;

@Component(role=RestConnector.class, hint="basic-config")
@Path(value="/config/{property: .*}")
public class ConfigEndpoint
extends AbstractRestConnector {
    @GET
    @Produces(value={"application/json"})
    public Response getConfig(@PathParam(value="property") String property) {
        MainPreferences prefs = CloudManagerApplicationHolder.getInstance().getRootPreferences();
        String value = prefs.getStringValue(property);
        JSONObject result = new JSONObject();
        try {
            result.put("name", (Object)property);
            if (value != null) {
                result.put("value", (Object)value);
            } else {
                result.put("empty", true);
            }
            return this.wrapResultObject(result);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response setConfig(@PathParam(value="property") String property, @FormParam(value="value") String value) {
        String nextChild;
        if (property == null || "".equals(property)) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid configuration path");
            return this.createErrorObject(iae.getMessage(), iae);
        }
        MainPreferences prefs = CloudManagerApplicationHolder.getInstance().getRootPreferences();
        SimplePreferences mutablePrefs = null;
        while (property.contains("/") && prefs.getChildNode(nextChild = property.substring(0, property.indexOf(47))) != null) {
            prefs = prefs.getChildNode(nextChild);
            property = property.substring(property.indexOf(47) + 1);
        }
        mutablePrefs = new SimplePreferences(null);
        ConfigUtil.copyPreferences((Preferences)prefs, (MutablePreferences)mutablePrefs);
        mutablePrefs.setValue(property, value);
        try {
            CloudManagerApp.getInstance().getConfigManager().applyConfig((Preferences)mutablePrefs, prefs);
        }
        catch (ConfigException e) {
            return this.createErrorObject(e.getMessage(), e);
        }
        return this.getConfig(property);
    }
}

