/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.resourcegroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aludratest.cloud.app.CloudManagerApp;
import org.aludratest.cloud.config.ConfigException;
import org.aludratest.cloud.config.ConfigUtil;
import org.aludratest.cloud.config.Configurable;
import org.aludratest.cloud.config.MainPreferences;
import org.aludratest.cloud.config.MutablePreferences;
import org.aludratest.cloud.config.Preferences;
import org.aludratest.cloud.config.PreferencesListener;
import org.aludratest.cloud.config.SimplePreferences;
import org.aludratest.cloud.config.admin.AbstractConfigurationAdmin;
import org.aludratest.cloud.config.admin.ConfigurationAdmin;
import org.aludratest.cloud.impl.resourcegroup.ResourceGroupManagerImplMBean;
import org.aludratest.cloud.module.ResourceModule;
import org.aludratest.cloud.resource.Resource;
import org.aludratest.cloud.resource.ResourceStateHolder;
import org.aludratest.cloud.resource.ResourceType;
import org.aludratest.cloud.resourcegroup.ResourceGroup;
import org.aludratest.cloud.resourcegroup.ResourceGroupManager;
import org.aludratest.cloud.resourcegroup.ResourceGroupManagerAdmin;
import org.aludratest.cloud.resourcegroup.ResourceGroupManagerListener;
import org.aludratest.cloud.resourcegroup.ResourceGroupNature;
import org.aludratest.cloud.resourcegroup.ResourceGroupNatureAssociation;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.json.JSONArray;
import org.json.JSONException;
import org.slf4j.LoggerFactory;

@Component(role=ResourceGroupManager.class, hint="default")
public class ResourceGroupManagerImpl
implements ResourceGroupManager,
Configurable,
ResourceGroupManagerImplMBean {
    private static final String METADATA_PREFS_NODE = "groupMetadata";
    private static final String METADATA_TYPE_PREF_KEY = "resourceType";
    private static final String METADATA_NAME_PREF_KEY = "groupName";
    private static final String METADATA_RANK_PREF_KEY = "rank";
    private static final String METADATA_NATURES_PREF_KEY = "groupNatures";
    private Map<Integer, ResourceGroup> resourceGroups = new HashMap<Integer, ResourceGroup>();
    private Map<Integer, Map<String, ResourceGroupNatureAssociation>> natureAssociations = new HashMap<Integer, Map<String, ResourceGroupNatureAssociation>>();
    private Map<Integer, ResourceGroupMetadata> resourceGroupMetadata = new HashMap<Integer, ResourceGroupMetadata>();
    private List<ResourceGroupManagerListener> listeners = new ArrayList<ResourceGroupManagerListener>();
    private ArrayList<ResourceModule> availableModules;
    @Requirement(role=ResourceGroupNature.class)
    private Map<String, ResourceGroupNature> availableNatures;
    private MainPreferences preferences;
    private PreferencesListener preferencesListener = new PreferencesListener(){

        public void preferencesChanged(Preferences oldPreferences, MainPreferences newPreferences) throws ConfigException {
            ResourceGroupManagerImpl.this.configure(newPreferences);
        }

        public void preferencesAboutToChange(Preferences oldPreferences, Preferences newPreferences) throws ConfigException {
            ResourceGroupManagerImpl.this.validateConfiguration(newPreferences);
        }
    };

    public ResourceGroupManagerImpl() {
        this.availableModules = new ArrayList(CloudManagerApp.getInstance().getAllResourceModules());
    }

    public synchronized void addResourceGroupManagerListener(ResourceGroupManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeResourceGroupManagerListener(ResourceGroupManagerListener listener) {
        this.listeners.remove(listener);
    }

    public void fillDefaults(MutablePreferences preferences) {
    }

    public void validateConfiguration(Preferences preferences) throws ConfigException {
    }

    public void setPreferences(MainPreferences preferences) throws ConfigException {
        if (this.preferences != null) {
            this.preferences.removePreferencesListener(this.preferencesListener);
        }
        this.preferences = preferences;
        preferences.addPreferencesListener(this.preferencesListener);
        this.configure(preferences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(MainPreferences preferences) throws ConfigException {
        HashSet<Integer> addedIds;
        HashSet<Integer> removedIds;
        Map<Integer, ResourceGroupMetadata> newMeta = this.readMetadata((Preferences)preferences);
        HashMap<Integer, HashSet<String>> addedNatures = new HashMap<Integer, HashSet<String>>();
        HashMap<Integer, HashSet<String>> removedNatures = new HashMap<Integer, HashSet<String>>();
        Object object = this;
        synchronized (object) {
            removedIds = new HashSet<Integer>(this.resourceGroupMetadata.keySet());
            removedIds.removeAll(newMeta.keySet());
            addedIds = new HashSet<Integer>(newMeta.keySet());
            addedIds.removeAll(this.resourceGroupMetadata.keySet());
            HashSet<Integer> unchangedIds = new HashSet<Integer>(this.resourceGroupMetadata.keySet());
            unchangedIds.retainAll(newMeta.keySet());
            for (Integer id : unchangedIds) {
                HashSet<String> set = new HashSet<String>(this.resourceGroupMetadata.get(id).getNatures());
                set.removeAll(newMeta.get(id).getNatures());
                removedNatures.put(id, set);
                set = new HashSet<String>(newMeta.get(id).getNatures());
                set.removeAll(this.resourceGroupMetadata.get(id).getNatures());
                addedNatures.put(id, set);
            }
        }
        for (Integer id : removedIds) {
            this.internalRemove(id);
        }
        for (Integer id : addedIds) {
            this.internalAdd(id, newMeta.get(id), preferences.getOrCreateChildNode(id.toString()));
        }
        for (Integer id : addedNatures.keySet()) {
            for (String nature : (Set)addedNatures.get(id)) {
                this.addNature(id, this.getResourceGroup(id), nature, preferences.getOrCreateChildNode(id.toString()));
            }
        }
        for (Integer id : removedNatures.keySet()) {
            for (String nature : (Set)removedNatures.get(id)) {
                this.removeNature(id, nature, preferences.getOrCreateChildNode(id.toString()));
            }
        }
        object = this;
        synchronized (object) {
            this.resourceGroupMetadata.clear();
            this.resourceGroupMetadata.putAll(newMeta);
        }
    }

    public synchronized int[] getAllResourceGroupIds() {
        int[] result = new int[this.resourceGroupMetadata.size()];
        ArrayList<Integer> ids = new ArrayList<Integer>(this.resourceGroupMetadata.keySet());
        Collections.sort(ids, new Comparator<Integer>(){

            @Override
            public int compare(Integer id1, Integer id2) {
                ResourceGroupMetadata meta1 = (ResourceGroupMetadata)ResourceGroupManagerImpl.this.resourceGroupMetadata.get(id1);
                ResourceGroupMetadata meta2 = (ResourceGroupMetadata)ResourceGroupManagerImpl.this.resourceGroupMetadata.get(id2);
                return meta1.getRank() - meta2.getRank();
            }
        });
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)ids.get(i);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceGroup getResourceGroup(int id) {
        ResourceGroupManagerImpl resourceGroupManagerImpl = this;
        synchronized (resourceGroupManagerImpl) {
            return this.resourceGroups.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResourceGroupName(int id) {
        ResourceGroupManagerImpl resourceGroupManagerImpl = this;
        synchronized (resourceGroupManagerImpl) {
            ResourceGroupMetadata meta = this.resourceGroupMetadata.get(id);
            return meta == null ? null : meta.getName();
        }
    }

    public <T extends ConfigurationAdmin> T getAdminInterface(Class<T> ifaceClass) {
        if (ifaceClass == ResourceGroupManagerAdmin.class) {
            return (T)((Object)new GroupManagerAdminImpl());
        }
        return null;
    }

    public List<ResourceGroupNature> getAvailableNaturesFor(int groupId) {
        ResourceGroup group = this.getResourceGroup(groupId);
        if (group == null) {
            return Collections.emptyList();
        }
        ArrayList<ResourceGroupNature> result = new ArrayList<ResourceGroupNature>();
        for (ResourceGroupNature nature : this.availableNatures.values()) {
            if (!nature.isAvailableFor(group)) continue;
            result.add(nature);
        }
        return result;
    }

    public ResourceGroupNatureAssociation getNatureAssociation(int groupId, String nature) {
        ResourceGroup group = this.getResourceGroup(groupId);
        if (group == null) {
            return null;
        }
        Map<String, ResourceGroupNatureAssociation> assocMap = this.natureAssociations.get(groupId);
        return assocMap.get(nature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceModule getResourceModule(String resourceTypeName) {
        ResourceModule module = null;
        ResourceGroupManagerImpl resourceGroupManagerImpl = this;
        synchronized (resourceGroupManagerImpl) {
            for (ResourceModule m : this.availableModules) {
                if (!resourceTypeName.equals(m.getResourceType().getName())) continue;
                module = m;
                break;
            }
        }
        return module;
    }

    private ResourceGroupNature getNature(String natureName) {
        return this.availableNatures == null ? null : this.availableNatures.get(natureName);
    }

    private void internalRemove(Integer groupId) {
        ResourceGroup group = this.getResourceGroup(groupId);
        if (group != null) {
            this.resourceGroups.remove(groupId);
            Map<String, ResourceGroupNatureAssociation> assocMap = this.natureAssociations.get(groupId);
            if (assocMap != null) {
                for (String natureName : new HashSet<String>(assocMap.keySet())) {
                    this.removeNature(groupId, natureName, this.preferences.getOrCreateChildNode(groupId.toString()));
                }
            }
            this.fireResourceGroupRemoved(group);
        }
    }

    private void internalAdd(Integer groupId, ResourceGroupMetadata metadata, MainPreferences groupConfig) throws ConfigException {
        ResourceModule module = this.getResourceModule(metadata.getResourceType().getName());
        if (module == null) {
            return;
        }
        ResourceGroup group = module.createResourceGroup();
        if (group instanceof Configurable) {
            ((Configurable)group).setPreferences(groupConfig);
        }
        this.resourceGroups.put(groupId, group);
        for (String natureName : metadata.getNatures()) {
            this.addNature(groupId, group, natureName, groupConfig);
        }
        this.fireResourceGroupAdded(group);
    }

    private void addNature(Integer groupId, ResourceGroup group, String natureName, MainPreferences groupConfig) throws ConfigException {
        Map<String, ResourceGroupNatureAssociation> assocMap;
        ResourceGroupNature nature = this.getNature(natureName);
        if (nature == null) {
            return;
        }
        ResourceGroupNatureAssociation assoc = nature.createAssociationFor(group);
        if (assoc instanceof Configurable) {
            MainPreferences naturePrefs = groupConfig.getOrCreateChildNode("natures");
            if (naturePrefs.getChildNode(natureName) == null) {
                SimplePreferences defPrefs = new SimplePreferences(null);
                ((Configurable)assoc).fillDefaults((MutablePreferences)defPrefs);
                MainPreferences prefs = naturePrefs.getOrCreateChildNode(natureName);
                CloudManagerApp.getInstance().getConfigManager().applyConfig((Preferences)defPrefs, prefs);
            }
            MainPreferences prefs = naturePrefs.getChildNode(natureName);
            ((Configurable)assoc).setPreferences(prefs);
        }
        if ((assocMap = this.natureAssociations.get(groupId)) == null) {
            assocMap = new HashMap<String, ResourceGroupNatureAssociation>();
            this.natureAssociations.put(groupId, assocMap);
        }
        assocMap.put(natureName, assoc);
        assoc.init();
    }

    private void removeNature(Integer groupId, String natureName, MainPreferences groupConfig) {
        Map<String, ResourceGroupNatureAssociation> assocMap = this.natureAssociations.get(groupId);
        if (assocMap != null) {
            MainPreferences naturePrefs;
            ResourceGroupNatureAssociation assoc = assocMap.remove(natureName);
            if (assoc != null) {
                assoc.detach();
            }
            if (assocMap.isEmpty()) {
                this.natureAssociations.remove(groupId);
            }
            if ((naturePrefs = groupConfig.getChildNode("natures")) != null && naturePrefs.getChildNode(natureName) != null) {
                SimplePreferences changePrefs = new SimplePreferences(null);
                ConfigUtil.copyPreferences((Preferences)naturePrefs, (MutablePreferences)changePrefs);
                changePrefs.removeChildNode(natureName);
                try {
                    CloudManagerApp.getInstance().getConfigManager().applyConfig((Preferences)changePrefs, naturePrefs);
                }
                catch (ConfigException e) {
                    LoggerFactory.getLogger(ResourceGroupManagerImpl.class).error("Could not remove group nature", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireResourceGroupAdded(ResourceGroup resourceGroup) {
        ArrayList<ResourceGroupManagerListener> listeners;
        ResourceGroupManagerImpl resourceGroupManagerImpl = this;
        synchronized (resourceGroupManagerImpl) {
            listeners = new ArrayList<ResourceGroupManagerListener>(this.listeners);
        }
        for (ResourceGroupManagerListener listener : listeners) {
            listener.resourceGroupAdded(resourceGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireResourceGroupRemoved(ResourceGroup resourceGroup) {
        ArrayList<ResourceGroupManagerListener> listeners;
        ResourceGroupManagerImpl resourceGroupManagerImpl = this;
        synchronized (resourceGroupManagerImpl) {
            listeners = new ArrayList<ResourceGroupManagerListener>(this.listeners);
        }
        for (ResourceGroupManagerListener listener : listeners) {
            listener.resourceGroupRemoved(resourceGroup);
        }
    }

    private Map<Integer, ResourceGroupMetadata> readMetadata(Preferences preferences) throws ConfigException {
        Preferences metaPrefs = preferences.getChildNode(METADATA_PREFS_NODE);
        if (metaPrefs == null) {
            return Collections.emptyMap();
        }
        HashMap<Integer, ResourceGroupMetadata> result = new HashMap<Integer, ResourceGroupMetadata>();
        for (String node : metaPrefs.getChildNodeNames()) {
            if (!node.matches("[0-9]{1,10}")) continue;
            Integer id = Integer.valueOf(node);
            Preferences prefs = metaPrefs.getChildNode(node);
            String typeName = prefs.getStringValue(METADATA_TYPE_PREF_KEY);
            if (typeName == null) continue;
            ResourceModule module = this.getResourceModule(typeName);
            if (module == null) {
                throw new ConfigException("Unsupported resource type: " + typeName);
            }
            String natureJson = prefs.getStringValue(METADATA_NATURES_PREF_KEY);
            List<String> natures = Collections.emptyList();
            if (natureJson != null) {
                natures = ResourceGroupManagerImpl.jsonArrayToStringList(natureJson);
            }
            result.put(id, new ResourceGroupMetadata(prefs.getStringValue(METADATA_NAME_PREF_KEY), prefs.getIntValue(METADATA_RANK_PREF_KEY), module.getResourceType(), natures));
        }
        return result;
    }

    @Override
    public List<Resource> getResourcesOfGroup(int groupId) {
        ResourceGroup group = this.getResourceGroup(groupId);
        if (group == null) {
            return null;
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (ResourceStateHolder rsh : group.getResourceCollection()) {
            if (!(rsh instanceof Resource)) continue;
            result.add((Resource)rsh);
        }
        return result;
    }

    private static List<String> jsonArrayToStringList(String jsonArraySource) {
        try {
            JSONArray arr = new JSONArray(jsonArraySource);
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < arr.length(); ++i) {
                result.add(arr.getString(i));
            }
            return result;
        }
        catch (JSONException e) {
            return Collections.emptyList();
        }
    }

    private static class ResourceGroupMetadata {
        private String name;
        private int rank;
        private ResourceType resourceType;
        private List<String> natures;

        public ResourceGroupMetadata(String name, int rank, ResourceType resourceType, List<String> natures) {
            this.name = name;
            this.rank = rank;
            this.resourceType = resourceType;
            this.natures = natures;
        }

        public String getName() {
            return this.name;
        }

        public int getRank() {
            return this.rank;
        }

        public ResourceType getResourceType() {
            return this.resourceType;
        }

        public List<String> getNatures() {
            return this.natures;
        }
    }

    private class GroupManagerAdminImpl
    extends AbstractConfigurationAdmin
    implements ResourceGroupManagerAdmin {
        protected GroupManagerAdminImpl() {
            super(ResourceGroupManagerImpl.this.preferences);
        }

        public void commit() throws ConfigException {
            this.cleanupRanks();
            super.commit();
        }

        public void renameResourceGroup(int id, String newName) throws ConfigException {
            this.assertNotCommitted();
            if (newName == null || "".equals(newName)) {
                throw new ConfigException("Please specify a valid name for the group");
            }
            MutablePreferences metaPrefs = this.getPreferences().createChildNode(ResourceGroupManagerImpl.METADATA_PREFS_NODE);
            String groupNodeName = "" + id;
            this.setGroupName(metaPrefs, groupNodeName, newName);
        }

        public int createResourceGroup(ResourceType resourceType, String name) throws ConfigException {
            ResourceGroup group;
            this.assertNotCommitted();
            ResourceModule module = ResourceGroupManagerImpl.this.getResourceModule(resourceType.getName());
            if (module == null) {
                throw new IllegalArgumentException("Unsupported resource type: " + resourceType);
            }
            MutablePreferences metaPrefs = this.getPreferences().createChildNode(ResourceGroupManagerImpl.METADATA_PREFS_NODE);
            int nextId = metaPrefs.getIntValue("nextGroupId");
            if (nextId == 0) {
                List<String> nodeNames = Arrays.asList(metaPrefs.getChildNodeNames());
                nextId = -1;
                int i = 1;
                while (nextId == -1) {
                    if (!nodeNames.contains("" + i)) {
                        nextId = i;
                    }
                    ++i;
                }
            }
            if ((group = module.createResourceGroup()) instanceof Configurable) {
                MutablePreferences groupPrefs = this.getPreferences().createChildNode("" + nextId);
                ((Configurable)group).fillDefaults(groupPrefs);
            }
            int rank = metaPrefs.getChildNodeNames().length + 1;
            this.setGroupName(metaPrefs, "" + nextId, name);
            metaPrefs.setValue("nextId", nextId + 1);
            metaPrefs = metaPrefs.createChildNode("" + nextId);
            metaPrefs.setValue(ResourceGroupManagerImpl.METADATA_TYPE_PREF_KEY, resourceType.getName());
            metaPrefs.setValue(ResourceGroupManagerImpl.METADATA_RANK_PREF_KEY, rank);
            return nextId;
        }

        public void deleteResourceGroup(int id) {
            this.assertNotCommitted();
            String groupNode = "" + id;
            MutablePreferences metaPrefs = this.getPreferences().createChildNode(ResourceGroupManagerImpl.METADATA_PREFS_NODE);
            metaPrefs.removeChildNode(groupNode);
            this.getPreferences().removeChildNode(groupNode);
        }

        public void moveGroup(int id, boolean up) {
            String groupNode = "" + id;
            List<String> nodes = this.getMetaNodesSortedByRank();
            MutablePreferences metaPrefs = this.getPreferences().createChildNode(ResourceGroupManagerImpl.METADATA_PREFS_NODE);
            int index = nodes.indexOf(groupNode);
            if (up && index > 0) {
                int rank1 = metaPrefs.getChildNode(nodes.get(index - 1)).getIntValue(ResourceGroupManagerImpl.METADATA_RANK_PREF_KEY);
                int rank2 = metaPrefs.getChildNode(groupNode).getIntValue(ResourceGroupManagerImpl.METADATA_RANK_PREF_KEY);
                metaPrefs.createChildNode(nodes.get(index - 1)).setValue(ResourceGroupManagerImpl.METADATA_RANK_PREF_KEY, rank2);
                metaPrefs.createChildNode(groupNode).setValue(ResourceGroupManagerImpl.METADATA_RANK_PREF_KEY, rank1);
            } else if (!up && index >= 0 && index < nodes.size() - 1) {
                int rank1 = metaPrefs.getChildNode(nodes.get(index + 1)).getIntValue(ResourceGroupManagerImpl.METADATA_RANK_PREF_KEY);
                int rank2 = metaPrefs.getChildNode(groupNode).getIntValue(ResourceGroupManagerImpl.METADATA_RANK_PREF_KEY);
                metaPrefs.createChildNode(nodes.get(index + 1)).setValue(ResourceGroupManagerImpl.METADATA_RANK_PREF_KEY, rank2);
                metaPrefs.createChildNode(groupNode).setValue(ResourceGroupManagerImpl.METADATA_RANK_PREF_KEY, rank1);
            }
        }

        public void addGroupNature(int groupId, String natureName) {
            this.assertNotCommitted();
            ResourceGroupNature nature = ResourceGroupManagerImpl.this.getNature(natureName);
            if (nature == null) {
                throw new IllegalArgumentException("No group nature with name " + natureName + " found.");
            }
            MutablePreferences metaPrefs = this.getPreferences().createChildNode(ResourceGroupManagerImpl.METADATA_PREFS_NODE);
            String groupNodeName = "" + groupId;
            MutablePreferences groupPrefs = metaPrefs.createChildNode(groupNodeName);
            String oldJsonValue = groupPrefs.getStringValue(ResourceGroupManagerImpl.METADATA_NATURES_PREF_KEY);
            ArrayList<String> natures = new ArrayList<String>();
            if (oldJsonValue != null) {
                natures.addAll(ResourceGroupManagerImpl.jsonArrayToStringList(oldJsonValue));
            }
            if (!natures.contains(natureName)) {
                natures.add(natureName);
                groupPrefs.setValue(ResourceGroupManagerImpl.METADATA_NATURES_PREF_KEY, new JSONArray(natures).toString());
            }
        }

        public void removeGroupNature(int groupId, String natureName) {
            this.assertNotCommitted();
            ResourceGroupNature nature = ResourceGroupManagerImpl.this.getNature(natureName);
            if (nature == null) {
                throw new IllegalArgumentException("No group nature with name " + natureName + " found.");
            }
            MutablePreferences metaPrefs = this.getPreferences().createChildNode(ResourceGroupManagerImpl.METADATA_PREFS_NODE);
            String groupNodeName = "" + groupId;
            MutablePreferences groupPrefs = metaPrefs.createChildNode(groupNodeName);
            String oldJsonValue = groupPrefs.getStringValue(ResourceGroupManagerImpl.METADATA_NATURES_PREF_KEY);
            ArrayList natures = new ArrayList();
            if (oldJsonValue != null) {
                natures.addAll(ResourceGroupManagerImpl.jsonArrayToStringList(oldJsonValue));
            }
            if (natures.contains(natureName)) {
                natures.remove(natureName);
                groupPrefs.setValue(ResourceGroupManagerImpl.METADATA_NATURES_PREF_KEY, new JSONArray(natures).toString());
            }
        }

        public List<String> getGroupNatures(int groupId) {
            this.assertNotCommitted();
            MutablePreferences metaPrefs = this.getPreferences().createChildNode(ResourceGroupManagerImpl.METADATA_PREFS_NODE);
            String groupNodeName = "" + groupId;
            MutablePreferences groupPrefs = metaPrefs.createChildNode(groupNodeName);
            String jsonValue = groupPrefs.getStringValue(ResourceGroupManagerImpl.METADATA_NATURES_PREF_KEY);
            ArrayList<String> natures = new ArrayList<String>();
            if (jsonValue != null) {
                natures.addAll(ResourceGroupManagerImpl.jsonArrayToStringList(jsonValue));
            }
            return natures;
        }

        protected void validateConfig(Preferences preferences) throws ConfigException {
            ResourceGroupManagerImpl.this.validateConfiguration(preferences);
        }

        private void setGroupName(MutablePreferences metaPrefs, String groupNode, String newName) throws ConfigException {
            for (String nodeName : metaPrefs.getChildNodeNames()) {
                String groupName;
                if (nodeName.equals(groupNode) || !newName.equals(groupName = metaPrefs.getChildNode(nodeName).getStringValue(ResourceGroupManagerImpl.METADATA_NAME_PREF_KEY))) continue;
                throw new ConfigException("A group with the same name already exists.");
            }
            metaPrefs = metaPrefs.createChildNode(groupNode);
            metaPrefs.setValue(ResourceGroupManagerImpl.METADATA_NAME_PREF_KEY, newName);
        }

        private void cleanupRanks() {
            List<String> sortedIds = this.getMetaNodesSortedByRank();
            MutablePreferences metaPrefs = this.getPreferences().createChildNode(ResourceGroupManagerImpl.METADATA_PREFS_NODE);
            for (int i = 0; i < sortedIds.size(); ++i) {
                metaPrefs.createChildNode(sortedIds.get(i)).setValue(ResourceGroupManagerImpl.METADATA_RANK_PREF_KEY, i + 1);
            }
        }

        private List<String> getMetaNodesSortedByRank() {
            final MutablePreferences metaPrefs = this.getPreferences().createChildNode(ResourceGroupManagerImpl.METADATA_PREFS_NODE);
            ArrayList<String> sortedIds = new ArrayList<String>(Arrays.asList(metaPrefs.getChildNodeNames()));
            Collections.sort(sortedIds, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    int rank1 = metaPrefs.getChildNode(s1).getIntValue(ResourceGroupManagerImpl.METADATA_RANK_PREF_KEY);
                    int rank2 = metaPrefs.getChildNode(s2).getIntValue(ResourceGroupManagerImpl.METADATA_RANK_PREF_KEY);
                    return rank1 - rank2;
                }
            });
            return sortedIds;
        }
    }
}

