/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.request;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class GateKeeper {
    private final long separationTime;
    private AtomicInteger waitingThreads = new AtomicInteger();
    private AtomicLong lastContinuationTime = new AtomicLong();
    private AtomicLong maxFutureContinuationTime = new AtomicLong();

    public GateKeeper(long separationTime, TimeUnit timeUnit) {
        this.separationTime = timeUnit.toMillis(separationTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter() throws InterruptedException {
        long waitTime = 0L;
        GateKeeper gateKeeper = this;
        synchronized (gateKeeper) {
            long now = System.currentTimeMillis();
            int cnt = this.waitingThreads.getAndIncrement();
            if (cnt == 0) {
                waitTime = Math.max(0L, this.separationTime - (now - this.lastContinuationTime.get()));
                this.maxFutureContinuationTime.set(now + waitTime);
            } else {
                waitTime = this.maxFutureContinuationTime.get() - now + this.separationTime;
                this.maxFutureContinuationTime.addAndGet(this.separationTime);
            }
        }
        try {
            if (waitTime > 0L) {
                Thread.sleep(waitTime);
            }
        }
        finally {
            gateKeeper = this;
            synchronized (gateKeeper) {
                this.lastContinuationTime.set(System.currentTimeMillis());
                this.waitingThreads.decrementAndGet();
            }
        }
    }

    public int getWaitingThreads() {
        return this.waitingThreads.get();
    }
}

