/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.request;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aludratest.cloud.app.CloudManagerApp;
import org.aludratest.cloud.impl.request.ClientRequestHandler;
import org.aludratest.cloud.impl.request.GateKeeper;
import org.aludratest.cloud.impl.user.BasicAuthUtil;
import org.aludratest.cloud.user.User;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRequestServlet
extends HttpServlet {
    private static final long serialVersionUID = 4695231001799464144L;
    private static final int MAX_CONTENT_LENGTH = 2048;
    private static final Logger LOG = LoggerFactory.getLogger(ClientRequestServlet.class);
    private static boolean CONTENT_TYPE_CHECK_ENABLED = true;
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final Pattern PATTERN_RESOURCE_ID_URI = Pattern.compile("/([0-9a-fA-F]{16})");
    private ClientRequestHandler requestHandler;
    private GateKeeper requestSeparator = new GateKeeper(100L, TimeUnit.MILLISECONDS);
    static ClientRequestServlet instance;
    AtomicInteger waitingRequests = new AtomicInteger();

    public void init(ServletConfig config) throws ServletException {
        instance = this;
        super.init(config);
        this.requestHandler = new ClientRequestHandler(CloudManagerApp.getInstance().getResourceManager());
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this.requestHandler, new ObjectName("org.aludratest.cloud:type=ClientRequestHandler"));
        }
        catch (JMException e) {
            LOG.error("Could not register request handler in MBean Server", (Throwable)e);
        }
    }

    ClientRequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(400);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String uri = req.getServletPath();
        if (!"/resource".equals(uri)) {
            resp.sendError(404);
            return;
        }
        uri = req.getPathInfo();
        Matcher m = PATTERN_RESOURCE_ID_URI.matcher(uri);
        if (!m.matches()) {
            resp.sendError(404);
            return;
        }
        String resourceKey = m.group(1);
        if (this.requestHandler.handleReleaseRequest(resourceKey)) {
            resp.setStatus(200);
        } else {
            resp.sendError(404);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.requestSeparator.enter();
        }
        catch (InterruptedException e) {
            return;
        }
        LOG.debug("doPost() enter");
        try {
            if (req.getContentLength() > 2048) {
                LOG.debug("Detected request larger than max content length. Sending BAD_REQUEST.");
                resp.sendError(400);
                return;
            }
            String uri = req.getServletPath();
            if (!"/resource".equals(uri)) {
                LOG.debug("Detected request to other path than /resource. Sending NOT_FOUND.");
                resp.sendError(404);
                return;
            }
            User user = BasicAuthUtil.authenticate(req, resp);
            if (user == null) {
                LOG.debug("No or invalid user information in request. Aborting.");
                return;
            }
            String contentType = req.getContentType();
            if (contentType != null && contentType.contains(";")) {
                contentType = contentType.substring(0, contentType.indexOf(59));
            }
            if (CONTENT_TYPE_CHECK_ENABLED && !JSON_CONTENT_TYPE.equals(contentType)) {
                LOG.debug("Invalid content type detected. Sending BAD_REQUEST.");
                resp.sendError(400);
                return;
            }
            if (req.getCharacterEncoding() != null && !"UTF-8".equalsIgnoreCase(req.getCharacterEncoding())) {
                LOG.debug("Invalid character encoding detected. Sending BAD_REQUEST.");
                resp.sendError(400);
                return;
            }
            ServletInputStream data = req.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)data, (OutputStream)baos);
            data.close();
            String jsonSource = new String(baos.toByteArray(), "UTF-8");
            try {
                JSONObject requestObject = new JSONObject(jsonSource);
                this.waitingRequests.incrementAndGet();
                JSONObject resultObject = this.requestHandler.handleResourceRequest(user, requestObject);
                this.waitingRequests.decrementAndGet();
                StringWriter writer = new StringWriter();
                resultObject.write((Writer)writer);
                resp.setStatus(200);
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType(JSON_CONTENT_TYPE);
                byte[] resultData = writer.toString().getBytes("UTF-8");
                resp.setContentLength(resultData.length);
                try {
                    ServletOutputStream os = resp.getOutputStream();
                    os.write(resultData);
                    os.close();
                }
                catch (IOException e) {
                    if (resultObject.has("requestId")) {
                        this.requestHandler.abortWaitingRequest(resultObject.getString("requestId"));
                    }
                }
            }
            catch (JSONException e) {
                LOG.debug("JSON exception occurred. Sending BAD_REQUEST.");
                resp.sendError(400);
                LOG.debug("doPost() leave");
                return;
            }
        }
        finally {
            LOG.debug("doPost() leave");
        }
    }
}

