/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.request;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.aludratest.cloud.app.CloudManagerApp;
import org.aludratest.cloud.impl.app.CloudManagerApplicationHolder;
import org.aludratest.cloud.impl.app.DatabaseRequestLogger;
import org.aludratest.cloud.impl.request.ClientRequestImpl;
import org.aludratest.cloud.manager.ManagedResourceQuery;
import org.aludratest.cloud.manager.ResourceManager;
import org.aludratest.cloud.manager.ResourceManagerListener;
import org.aludratest.cloud.module.ResourceModule;
import org.aludratest.cloud.request.ResourceRequest;
import org.aludratest.cloud.resource.Resource;
import org.aludratest.cloud.resource.ResourceListener;
import org.aludratest.cloud.resource.ResourceState;
import org.aludratest.cloud.resource.UsableResource;
import org.aludratest.cloud.resource.user.ResourceTypeAuthorization;
import org.aludratest.cloud.resource.user.ResourceTypeAuthorizationConfig;
import org.aludratest.cloud.resource.writer.JSONResourceWriter;
import org.aludratest.cloud.resource.writer.ResourceWriterFactory;
import org.aludratest.cloud.user.StoreException;
import org.aludratest.cloud.user.User;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRequestHandler
implements ResourceManagerListener {
    private static final Logger LOG = LoggerFactory.getLogger(ClientRequestHandler.class);
    private Map<String, WaitingRequest> requestQueries = new HashMap<String, WaitingRequest>();
    private Map<String, Resource> activeResources = new HashMap<String, Resource>();
    private ScheduledExecutorService abortScheduler = Executors.newScheduledThreadPool(1);
    private ResourceManager manager;

    public ClientRequestHandler(ResourceManager manager) {
        this.manager = manager;
        manager.addResourceManagerListener((ResourceManagerListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject handleResourceRequest(User user, JSONObject object) throws JSONException {
        LOG.debug("Handling resource request for user " + user);
        try {
            if (object.has("requestId")) {
                String requestId = object.getString("requestId");
                return this.waitForFuture(requestId);
            }
            ResourceModule module = CloudManagerApp.getInstance().getResourceModule(object.getString("resourceType"));
            if (module == null) {
                return this.createErrorObject("Unknown resource type");
            }
            try {
                ResourceTypeAuthorizationConfig authConfig = CloudManagerApp.getInstance().getResourceTypeAuthorizationStore().loadResourceTypeAuthorizations(module.getResourceType());
                if (authConfig == null) {
                    return this.createErrorObject("User is not authorized for resource type " + module.getResourceType().getName());
                }
                ResourceTypeAuthorization auth = authConfig.getResourceTypeAuthorizationForUser(user);
                if (auth == null || auth.getMaxResources() == 0) {
                    return this.createErrorObject("User is not authorized for resource type " + module.getResourceType().getName());
                }
            }
            catch (StoreException authConfig) {
                // empty catch block
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (object.has("customAttributes")) {
                JSONObject attrs = object.getJSONObject("customAttributes");
                Iterator keys = attrs.keys();
                while (keys.hasNext()) {
                    String key = keys.next().toString();
                    attributes.put(key, attrs.getString(key));
                }
            }
            String name = "unnamed job";
            if (object.has("jobName")) {
                name = object.getString("jobName");
            }
            String requestId = this.generateUniqueRequestKey();
            ClientRequestImpl request = new ClientRequestImpl(requestId, user, module.getResourceType(), object.optInt("niceLevel", 0), name, attributes);
            DatabaseRequestLogger requestLogger = CloudManagerApplicationHolder.getInstance().getRequestLogger();
            long dbRequestId = requestLogger.createRequestLog(user, name);
            WaitingRequest wr = new WaitingRequest();
            wr.future = new WaitForResource();
            wr.dbRequestId = dbRequestId;
            wr.jobName = name;
            wr.user = user;
            LOG.debug("Request " + requestId + " started");
            ClientRequestHandler clientRequestHandler = this;
            synchronized (clientRequestHandler) {
                this.requestQueries.put(requestId, wr);
            }
            this.manager.handleResourceRequest((ResourceRequest)request);
            return this.waitForFuture(requestId);
        }
        catch (SQLException e) {
            return this.createErrorObject(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleReleaseRequest(String requestId) {
        Resource resource;
        LOG.debug("Releasing resource for request " + requestId);
        ClientRequestHandler clientRequestHandler = this;
        synchronized (clientRequestHandler) {
            resource = this.activeResources.remove(requestId);
        }
        if (resource == null) {
            return false;
        }
        if (resource instanceof UsableResource) {
            if (resource.getState() != ResourceState.IN_USE) {
                ((UsableResource)resource).startUsing();
            }
            ((UsableResource)resource).stopUsing();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortWaitingRequest(String requestId) {
        LOG.debug("Abort waiting request " + requestId);
        WaitingRequest wr = this.requestQueries.remove(requestId);
        if (wr != null) {
            if (wr.future.isDone()) {
                try {
                    Resource res = wr.future.get();
                    ClientRequestHandler clientRequestHandler = this;
                    synchronized (clientRequestHandler) {
                        this.activeResources.put(requestId, res);
                    }
                    this.handleReleaseRequest(requestId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            wr.future.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject waitForFuture(final String requestId) throws JSONException, SQLException {
        WaitingRequest request;
        ClientRequestHandler clientRequestHandler = this;
        synchronized (clientRequestHandler) {
            request = this.requestQueries.get(requestId);
            if (request == null) {
                return this.createErrorObject("Invalid request ID");
            }
        }
        if (request.abandonFuture != null) {
            request.abandonFuture.cancel(false);
        }
        try {
            Resource resource = request.future.get(10L, TimeUnit.SECONDS);
            ClientRequestHandler clientRequestHandler2 = this;
            synchronized (clientRequestHandler2) {
                this.requestQueries.remove(requestId);
                this.activeResources.put(requestId, resource);
            }
            this.startWorking(resource, request.user, request.jobName, request.dbRequestId);
            ResourceWriterFactory factory = CloudManagerApp.getInstance().getResourceWriterFactory(resource.getResourceType());
            factory.getResourceWriter(JSONResourceWriter.class);
            JSONResourceWriter writer = (JSONResourceWriter)factory.getResourceWriter(JSONResourceWriter.class);
            JSONObject resultObject = new JSONObject();
            resultObject.put("resourceType", (Object)resource.getResourceType().getName());
            resultObject.put("resource", (Object)writer.writeToJSON(resource));
            resultObject.put("requestId", (Object)requestId);
            return resultObject;
        }
        catch (ExecutionException e) {
            LOG.error("Execution exception when waiting for resource", (Throwable)e);
            return this.createErrorObject(e.getMessage());
        }
        catch (InterruptedException e) {
            return this.createErrorObject("AludraTest Cloud Manager server is shutting down");
        }
        catch (TimeoutException e) {
            JSONObject result = new JSONObject();
            result.put("requestId", (Object)requestId);
            result.put("waiting", true);
            request.abandonFuture = this.abortScheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    LOG.debug("Aborting inactive request " + requestId);
                    ClientRequestHandler.this.abortWaitingRequest(requestId);
                }
            }, 60L, TimeUnit.SECONDS);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resourceAvailable(ManagedResourceQuery request, Resource availableResource) {
        if (!(request.getRequest() instanceof ClientRequestImpl)) {
            return false;
        }
        ClientRequestImpl creq = (ClientRequestImpl)request.getRequest();
        String id = creq.getRequestId();
        ClientRequestHandler clientRequestHandler = this;
        synchronized (clientRequestHandler) {
            if (this.requestQueries.containsKey(id)) {
                WaitingRequest wr = this.requestQueries.get(id);
                wr.future.setResource(availableResource);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestError(ManagedResourceQuery request, String errorMessage, Throwable cause) {
        if (!(request.getRequest() instanceof ClientRequestImpl)) {
            return;
        }
        ClientRequestImpl creq = (ClientRequestImpl)request.getRequest();
        String id = creq.getRequestId();
        ClientRequestHandler clientRequestHandler = this;
        synchronized (clientRequestHandler) {
            if (this.requestQueries.containsKey(id)) {
                WaitingRequest wr = this.requestQueries.get(id);
                wr.future.setErrorMessage(errorMessage, cause);
            }
        }
    }

    public void requestEnqueued(ManagedResourceQuery request) {
    }

    public void resourceReleased(ManagedResourceQuery request, Resource releasedResource) {
    }

    private void startWorking(Resource resource, User user, String jobName, final long dbRequestId) throws SQLException {
        final DatabaseRequestLogger requestLogger = CloudManagerApplicationHolder.getInstance().getRequestLogger();
        if (resource instanceof UsableResource) {
            ((UsableResource)resource).startUsing();
        }
        requestLogger.updateRequestLogWorkStarted(dbRequestId, resource.getResourceType().getName(), resource.toString());
        resource.addResourceListener(new ResourceListener(){

            public void resourceStateChanged(Resource resource, ResourceState previousState, ResourceState newState) {
                if (previousState == ResourceState.IN_USE && newState != ResourceState.IN_USE) {
                    String reason;
                    switch (newState) {
                        case DISCONNECTED: {
                            reason = "RES_DISCONNECT";
                            break;
                        }
                        default: {
                            reason = "OK_RELEASED";
                        }
                    }
                    int cnt = 0;
                    for (ManagedResourceQuery query : ClientRequestHandler.this.manager.getAllRunningQueries()) {
                        if (!query.getRequest().getResourceType().equals(resource.getResourceType())) continue;
                        ++cnt;
                    }
                    requestLogger.updateRequestLogWorkDone(dbRequestId, reason, cnt);
                    resource.removeResourceListener((ResourceListener)this);
                }
            }
        });
    }

    private String generateUniqueRequestKey() {
        StringBuilder sb;
        String key = null;
        do {
            sb = new StringBuilder();
            for (int i = 0; i < 16; ++i) {
                sb.append(Integer.toHexString((int)(Math.random() * 16.0)));
            }
        } while (this.requestQueries.containsKey(key = sb.toString()) || this.activeResources.containsKey(key));
        return key;
    }

    private JSONObject createErrorObject(Throwable t) throws JSONException {
        return this.createErrorObject(t.getMessage());
    }

    private JSONObject createErrorObject(String errorMessage) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("errorMessage", (Object)errorMessage);
        return result;
    }

    JSONArray getRequestQueries() throws JSONException {
        JSONArray result = new JSONArray();
        for (Map.Entry<String, WaitingRequest> entry : this.requestQueries.entrySet()) {
            JSONObject obj = new JSONObject();
            obj.put("requestId", (Object)entry.getKey());
            JSONObject req = new JSONObject();
            req.put("jobName", (Object)entry.getValue().jobName);
            req.put("user", (Object)entry.getValue().user.getName());
            obj.put("request", (Object)req);
            result.put((Object)obj);
        }
        return result;
    }

    private static class WaitForResource
    implements Future<Resource> {
        private Resource resource;
        private String errorMessage;
        private Throwable cause;

        private WaitForResource() {
        }

        public synchronized void setResource(Resource resource) {
            this.resource = resource;
            this.notify();
        }

        public synchronized void setErrorMessage(String errorMessage, Throwable cause) {
            this.errorMessage = errorMessage;
            this.cause = cause;
            this.notify();
        }

        public synchronized Resource getResource() {
            return this.resource;
        }

        public synchronized String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public synchronized boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.getResource() != null;
        }

        @Override
        public Resource get() throws InterruptedException, ExecutionException {
            while (this.getResource() != null && this.getErrorMessage() != null) {
                this.wait(2000L);
            }
            if (this.getErrorMessage() != null) {
                throw new ExecutionException(this.errorMessage, this.cause);
            }
            return this.resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resource get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.getResource() != null) {
                return this.resource;
            }
            if (this.getErrorMessage() != null) {
                throw new ExecutionException(this.errorMessage, this.cause);
            }
            WaitForResource waitForResource = this;
            synchronized (waitForResource) {
                this.wait(TimeUnit.MILLISECONDS.convert(timeout, unit));
            }
            if (this.getErrorMessage() != null) {
                throw new ExecutionException(this.errorMessage, this.cause);
            }
            if (this.getResource() == null) {
                throw new TimeoutException();
            }
            return this.resource;
        }
    }

    private static class WaitingRequest {
        private WaitForResource future;
        private long dbRequestId;
        private User user;
        private String jobName;
        private ScheduledFuture<?> abandonFuture;

        private WaitingRequest() {
        }
    }
}

