/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.cloud.impl.request;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.aludratest.cloud.app.CloudManagerApp;
import org.aludratest.cloud.impl.request.ClientRequestServlet;
import org.aludratest.cloud.manager.ManagedResourceQuery;
import org.aludratest.cloud.manager.ResourceManager;
import org.aludratest.cloud.rest.AbstractRestConnector;
import org.aludratest.cloud.rest.RestConnector;
import org.codehaus.plexus.component.annotations.Component;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Component(role=RestConnector.class, hint="client-request")
@Path(value="/debug/requests")
public class ClientRequestDebugRestEndpoint
extends AbstractRestConnector {
    @GET
    @Path(value="/waiting")
    @Produces(value={"application/json"})
    public Response getWaitingRequests() throws JSONException {
        ClientRequestServlet servlet = ClientRequestServlet.instance;
        if (servlet == null || servlet.getRequestHandler() == null) {
            return Response.noContent().build();
        }
        JSONObject obj = new JSONObject();
        obj.put("waitingRequests", servlet.waitingRequests.get());
        return this.wrapResultObject(obj);
    }

    @GET
    @Path(value="/queue")
    @Produces(value={"application/json"})
    public Response getQueue() throws JSONException {
        ResourceManager manager = CloudManagerApp.getInstance().getResourceManager();
        JSONObject obj = new JSONObject();
        obj.put("queueSize", manager.getTotalQueueSize());
        return this.wrapResultObject(obj);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getKnownRequests() throws JSONException {
        ClientRequestServlet servlet = ClientRequestServlet.instance;
        if (servlet == null || servlet.getRequestHandler() == null) {
            return Response.noContent().build();
        }
        JSONObject obj = new JSONObject();
        obj.put("requests", (Object)servlet.getRequestHandler().getRequestQueries());
        return this.wrapResultObject(obj);
    }

    @GET
    @Path(value="/running")
    @Produces(value={"application/json"})
    public Response getRunningRequests() throws JSONException {
        ResourceManager manager = CloudManagerApp.getInstance().getResourceManager();
        JSONArray arr = new JSONArray();
        for (ManagedResourceQuery query : manager.getAllRunningQueries()) {
            JSONObject obj = new JSONObject();
            obj.put("user", (Object)query.getRequest().getRequestingUser().getName());
            obj.put("jobName", (Object)query.getRequest().getJobName());
            if (query.getReceivedResource() != null) {
                obj.put("receivedResource", (Object)query.getReceivedResource());
            }
            arr.put((Object)obj);
        }
        JSONObject obj = new JSONObject();
        obj.put("requests", (Object)arr);
        return this.wrapResultObject(obj);
    }
}

